/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.Context;
import io.deephaven.engine.table.FillContextMaker;
import io.deephaven.engine.table.GetContextMaker;
import org.jetbrains.annotations.NotNull;

public interface ChunkSource<ATTR extends Any>
extends FillContextMaker,
GetContextMaker {
    public static final ChunkSource[] ZERO_LENGTH_CHUNK_SOURCE_ARRAY = new ChunkSource[0];
    public static final FillContext DEFAULT_FILL_INSTANCE = new FillContext(){

        @Override
        public boolean supportsUnboundedFill() {
            return true;
        }
    };

    public ChunkType getChunkType();

    public Chunk<? extends ATTR> getChunk(@NotNull GetContext var1, @NotNull RowSequence var2);

    public Chunk<? extends ATTR> getChunk(@NotNull GetContext var1, long var2, long var4);

    public void fillChunk(@NotNull FillContext var1, @NotNull WritableChunk<? super ATTR> var2, @NotNull RowSequence var3);

    public static interface WithPrev<ATTR extends Any>
    extends ChunkSource<ATTR> {
        public static final WithPrev[] ZERO_LENGTH_CHUNK_SOURCE_WITH_PREV_ARRAY = new WithPrev[0];

        public Chunk<? extends ATTR> getPrevChunk(@NotNull GetContext var1, @NotNull RowSequence var2);

        public Chunk<? extends ATTR> getPrevChunk(@NotNull GetContext var1, long var2, long var4);

        public void fillPrevChunk(@NotNull FillContext var1, @NotNull WritableChunk<? super ATTR> var2, @NotNull RowSequence var3);

        public ChunkSource<ATTR> getPrevSource();
    }

    public static interface FillContext
    extends Context {
        default public boolean supportsUnboundedFill() {
            return false;
        }
    }

    public static interface GetContext
    extends Context {
    }
}

