/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table;

import io.deephaven.base.log.LogOutput;
import io.deephaven.base.log.LogOutputAppendable;
import io.deephaven.engine.table.TypeHelper;
import io.deephaven.io.log.impl.LogOutputStringImpl;
import io.deephaven.qst.column.header.ColumnHeader;
import io.deephaven.qst.type.ArrayType;
import io.deephaven.qst.type.BooleanType;
import io.deephaven.qst.type.BoxedType;
import io.deephaven.qst.type.ByteType;
import io.deephaven.qst.type.CharType;
import io.deephaven.qst.type.CustomType;
import io.deephaven.qst.type.DoubleType;
import io.deephaven.qst.type.FloatType;
import io.deephaven.qst.type.GenericType;
import io.deephaven.qst.type.GenericVectorType;
import io.deephaven.qst.type.InstantType;
import io.deephaven.qst.type.IntType;
import io.deephaven.qst.type.LongType;
import io.deephaven.qst.type.NativeArrayType;
import io.deephaven.qst.type.PrimitiveType;
import io.deephaven.qst.type.PrimitiveVectorType;
import io.deephaven.qst.type.ShortType;
import io.deephaven.qst.type.StringType;
import io.deephaven.qst.type.Type;
import io.deephaven.vector.ByteVector;
import io.deephaven.vector.CharVector;
import io.deephaven.vector.DoubleVector;
import io.deephaven.vector.FloatVector;
import io.deephaven.vector.IntVector;
import io.deephaven.vector.LongVector;
import io.deephaven.vector.ObjectVector;
import io.deephaven.vector.ShortVector;
import io.deephaven.vector.Vector;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColumnDefinition<TYPE>
implements LogOutputAppendable {
    public static final ColumnDefinition<?>[] ZERO_LENGTH_COLUMN_DEFINITION_ARRAY = new ColumnDefinition[0];
    @NotNull
    private final String name;
    @NotNull
    private final Class<TYPE> dataType;
    @Nullable
    private final Class<?> componentType;
    @NotNull
    private final ColumnType columnType;

    public static ColumnDefinition<Boolean> ofBoolean(@NotNull String name) {
        return new ColumnDefinition<Boolean>(name, Boolean.class);
    }

    public static ColumnDefinition<Byte> ofByte(@NotNull String name) {
        return new ColumnDefinition<Byte>(name, Byte.TYPE);
    }

    public static ColumnDefinition<Character> ofChar(@NotNull String name) {
        return new ColumnDefinition<Character>(name, Character.TYPE);
    }

    public static ColumnDefinition<Short> ofShort(@NotNull String name) {
        return new ColumnDefinition<Short>(name, Short.TYPE);
    }

    public static ColumnDefinition<Integer> ofInt(@NotNull String name) {
        return new ColumnDefinition<Integer>(name, Integer.TYPE);
    }

    public static ColumnDefinition<Long> ofLong(@NotNull String name) {
        return new ColumnDefinition<Long>(name, Long.TYPE);
    }

    public static ColumnDefinition<Float> ofFloat(@NotNull String name) {
        return new ColumnDefinition<Float>(name, Float.TYPE);
    }

    public static ColumnDefinition<Double> ofDouble(@NotNull String name) {
        return new ColumnDefinition<Double>(name, Double.TYPE);
    }

    public static ColumnDefinition<String> ofString(@NotNull String name) {
        return new ColumnDefinition<String>(name, String.class);
    }

    public static ColumnDefinition<Instant> ofTime(@NotNull String name) {
        return new ColumnDefinition<Instant>(name, Instant.class);
    }

    public static ColumnDefinition<?> of(String name, Type<?> type) {
        return (ColumnDefinition)type.walk((Type.Visitor)new Adapter(name));
    }

    public static ColumnDefinition<?> of(String name, PrimitiveType<?> type) {
        Adapter adapter = new Adapter(name);
        return (ColumnDefinition)type.walk((PrimitiveType.Visitor)adapter);
    }

    public static ColumnDefinition<?> of(String name, GenericType<?> type) {
        Adapter adapter = new Adapter(name);
        return (ColumnDefinition)type.walk((GenericType.Visitor)adapter);
    }

    public static <T extends Vector<?>> ColumnDefinition<T> ofVector(@NotNull String name, @NotNull Class<T> vectorType) {
        return new ColumnDefinition<T>(name, vectorType, ColumnDefinition.baseComponentTypeForVector(vectorType), ColumnType.Normal);
    }

    public static <T> ColumnDefinition<T> fromGenericType(@NotNull String name, @NotNull Class<T> dataType) {
        return ColumnDefinition.fromGenericType(name, dataType, null);
    }

    public static <T> ColumnDefinition<T> fromGenericType(@NotNull String name, @NotNull Class<T> dataType, @Nullable Class<?> componentType) {
        return ColumnDefinition.fromGenericType(name, dataType, componentType, ColumnType.Normal);
    }

    public static <T> ColumnDefinition<T> fromGenericType(@NotNull String name, @NotNull Class<T> dataType, @Nullable Class<?> componentType, @NotNull ColumnType columnType) {
        return new ColumnDefinition<T>(name, dataType, ColumnDefinition.checkAndMaybeInferComponentType(dataType, componentType), columnType);
    }

    private static Class<?> baseComponentTypeForVector(@NotNull Class<? extends Vector<?>> vectorType) {
        if (CharVector.class.isAssignableFrom(vectorType)) {
            return Character.TYPE;
        }
        if (ByteVector.class.isAssignableFrom(vectorType)) {
            return Byte.TYPE;
        }
        if (ShortVector.class.isAssignableFrom(vectorType)) {
            return Short.TYPE;
        }
        if (IntVector.class.isAssignableFrom(vectorType)) {
            return Integer.TYPE;
        }
        if (LongVector.class.isAssignableFrom(vectorType)) {
            return Long.TYPE;
        }
        if (FloatVector.class.isAssignableFrom(vectorType)) {
            return Float.TYPE;
        }
        if (DoubleVector.class.isAssignableFrom(vectorType)) {
            return Double.TYPE;
        }
        if (ObjectVector.class.isAssignableFrom(vectorType)) {
            return Object.class;
        }
        throw new IllegalArgumentException("Unrecognized Vector type " + vectorType);
    }

    private static void assertComponentTypeValid(@NotNull Class<?> dataType, @Nullable Class<?> componentType) {
        if (!Vector.class.isAssignableFrom(dataType) && !dataType.isArray()) {
            return;
        }
        if (componentType == null) {
            throw new IllegalArgumentException("Required component type not specified for data type " + dataType);
        }
        if (dataType.isArray()) {
            Class<?> arrayComponentType = dataType.getComponentType();
            if (!arrayComponentType.isAssignableFrom(componentType)) {
                throw new IllegalArgumentException("Invalid component type " + componentType + " for array data type " + dataType);
            }
            return;
        }
        Class<?> baseComponentType = ColumnDefinition.baseComponentTypeForVector(dataType);
        if (!baseComponentType.isAssignableFrom(componentType)) {
            throw new IllegalArgumentException("Invalid component type " + componentType + " for Vector data type " + dataType);
        }
    }

    private static Class<?> checkAndMaybeInferComponentType(@NotNull Class<?> dataType, @Nullable Class<?> inputComponentType) {
        if (dataType.isArray()) {
            Class<?> arrayComponentType = dataType.getComponentType();
            if (inputComponentType == null) {
                return arrayComponentType;
            }
            if (!arrayComponentType.isAssignableFrom(inputComponentType)) {
                throw new IllegalArgumentException("Invalid component type " + inputComponentType + " for array data type " + dataType);
            }
            return inputComponentType;
        }
        if (Vector.class.isAssignableFrom(dataType)) {
            Class<?> vectorComponentType = ColumnDefinition.baseComponentTypeForVector(dataType);
            if (inputComponentType == null) {
                return vectorComponentType;
            }
            if (!vectorComponentType.isAssignableFrom(inputComponentType)) {
                throw new IllegalArgumentException("Invalid component type " + inputComponentType + " for Vector data type " + dataType);
            }
            return inputComponentType;
        }
        return inputComponentType;
    }

    public static ColumnDefinition<?> from(ColumnHeader<?> header) {
        return (ColumnDefinition)header.componentType().walk((Type.Visitor)new Adapter(header.name()));
    }

    private ColumnDefinition(@NotNull String name, @NotNull Class<TYPE> dataType) {
        this(name, dataType, null, ColumnType.Normal);
    }

    private ColumnDefinition(@NotNull String name, @NotNull Class<TYPE> dataType, @Nullable Class<?> componentType, @NotNull ColumnType columnType) {
        this.name = Objects.requireNonNull(name, "Column names cannot be null");
        this.dataType = Objects.requireNonNull(dataType);
        this.componentType = componentType;
        this.columnType = Objects.requireNonNull(columnType);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public Class<TYPE> getDataType() {
        return this.dataType;
    }

    @Nullable
    public Class<?> getComponentType() {
        return this.componentType;
    }

    @NotNull
    public ColumnType getColumnType() {
        return this.columnType;
    }

    public ColumnDefinition<TYPE> withPartitioning() {
        return this.isPartitioning() ? this : new ColumnDefinition<TYPE>(this.name, this.dataType, this.componentType, ColumnType.Partitioning);
    }

    public ColumnDefinition<TYPE> withGrouping() {
        return this.isGrouping() ? this : new ColumnDefinition<TYPE>(this.name, this.dataType, this.componentType, ColumnType.Grouping);
    }

    public ColumnDefinition<TYPE> withNormal() {
        return this.columnType == ColumnType.Normal ? this : new ColumnDefinition<TYPE>(this.name, this.dataType, this.componentType, ColumnType.Normal);
    }

    public <Other> ColumnDefinition<Other> withDataType(@NotNull Class<Other> newDataType) {
        return this.dataType == newDataType ? this : ColumnDefinition.fromGenericType(this.name, newDataType, this.componentType, this.columnType);
    }

    public ColumnDefinition<?> withName(@NotNull String newName) {
        return newName.equals(this.name) ? this : new ColumnDefinition<TYPE>(newName, this.dataType, this.componentType, this.columnType);
    }

    public boolean isGrouping() {
        return this.columnType == ColumnType.Grouping;
    }

    public boolean isPartitioning() {
        return this.columnType == ColumnType.Partitioning;
    }

    public boolean isDirect() {
        return this.columnType == ColumnType.Normal || this.columnType == ColumnType.Grouping;
    }

    public boolean isCompatible(@NotNull ColumnDefinition<?> other) {
        if (this == other) {
            return true;
        }
        return this.name.equals(other.name) && this.dataType == other.dataType && this.componentType == other.componentType;
    }

    public boolean hasCompatibleDataType(@NotNull ColumnDefinition<?> other) {
        return this.dataType == other.dataType && this.componentType == other.componentType;
    }

    public String describeForCompatibility() {
        if (this.componentType == null) {
            return String.format("[%s, %s]", this.name, this.dataType);
        }
        return String.format("[%s, %s, %s]", this.name, this.dataType, this.componentType);
    }

    public void describeDifferences(@NotNull List<String> differences, @NotNull ColumnDefinition<?> other, @NotNull String lhs, @NotNull String rhs, @NotNull String prefix, boolean includeColumnType) {
        if (this == other) {
            return;
        }
        if (!this.name.equals(other.name)) {
            differences.add(prefix + lhs + " name '" + this.name + "' does not match " + rhs + " name '" + other.name + "'");
        }
        if (this.dataType != other.dataType) {
            differences.add(prefix + lhs + " dataType '" + this.dataType + "' does not match " + rhs + " dataType '" + other.dataType + "'");
        } else {
            if (this.componentType != other.componentType) {
                differences.add(prefix + lhs + " componentType '" + this.componentType + "' does not match " + rhs + " componentType '" + other.componentType + "'");
            }
            if (includeColumnType && this.columnType != other.columnType) {
                differences.add(prefix + lhs + " columnType " + this.columnType + " does not match " + rhs + " columnType " + other.columnType);
            }
        }
    }

    public final void checkCastTo(Class<?> destDataType) {
        TypeHelper.checkCastTo("[" + this.name + "]", this.dataType, destDataType);
    }

    public final void checkCastTo(Class<?> destDataType, @Nullable Class<?> destComponentType) {
        TypeHelper.checkCastTo("[" + this.name + "]", this.dataType, this.componentType, destDataType, destComponentType);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ColumnDefinition)) {
            return false;
        }
        ColumnDefinition otherCD = (ColumnDefinition)other;
        return this.name.equals(otherCD.name) && this.dataType == otherCD.dataType && this.componentType == otherCD.componentType && this.columnType == otherCD.columnType;
    }

    public int hashCode() {
        return (((31 + this.name.hashCode()) * 31 + this.dataType.hashCode()) * 31 + Objects.hashCode(this.componentType)) * 31 + this.columnType.hashCode();
    }

    public String toString() {
        return new LogOutputStringImpl().append((LogOutputAppendable)this).toString();
    }

    public LogOutput append(LogOutput logOutput) {
        return logOutput.append((CharSequence)"ColumnDefinition {").append((CharSequence)"name=").append((CharSequence)this.name).append((CharSequence)", dataType=").append((CharSequence)String.valueOf(this.dataType)).append((CharSequence)", componentType=").append((CharSequence)String.valueOf(this.componentType)).append((CharSequence)", columnType=").append((CharSequence)this.columnType.name()).append('}');
    }

    private static class Adapter
    implements Type.Visitor<ColumnDefinition<?>>,
    PrimitiveType.Visitor<ColumnDefinition<?>>,
    GenericType.Visitor<ColumnDefinition<?>> {
        private final String name;

        public Adapter(String name) {
            this.name = Objects.requireNonNull(name);
        }

        public ColumnDefinition<?> visit(PrimitiveType<?> primitiveType) {
            return (ColumnDefinition)primitiveType.walk((PrimitiveType.Visitor)this);
        }

        public ColumnDefinition<?> visit(GenericType<?> genericType) {
            return (ColumnDefinition)genericType.walk((GenericType.Visitor)this);
        }

        public ColumnDefinition<?> visit(BooleanType booleanType) {
            return ColumnDefinition.ofBoolean(this.name);
        }

        public ColumnDefinition<?> visit(ByteType byteType) {
            return ColumnDefinition.ofByte(this.name);
        }

        public ColumnDefinition<?> visit(CharType charType) {
            return ColumnDefinition.ofChar(this.name);
        }

        public ColumnDefinition<?> visit(ShortType shortType) {
            return ColumnDefinition.ofShort(this.name);
        }

        public ColumnDefinition<?> visit(IntType intType) {
            return ColumnDefinition.ofInt(this.name);
        }

        public ColumnDefinition<?> visit(LongType longType) {
            return ColumnDefinition.ofLong(this.name);
        }

        public ColumnDefinition<?> visit(FloatType floatType) {
            return ColumnDefinition.ofFloat(this.name);
        }

        public ColumnDefinition<?> visit(DoubleType doubleType) {
            return ColumnDefinition.ofDouble(this.name);
        }

        public ColumnDefinition<?> visit(BoxedType<?> boxedType) {
            return this.visit(boxedType.primitiveType());
        }

        public ColumnDefinition<?> visit(StringType stringType) {
            return ColumnDefinition.ofString(this.name);
        }

        public ColumnDefinition<?> visit(InstantType instantType) {
            return ColumnDefinition.ofTime(this.name);
        }

        public ColumnDefinition<?> visit(ArrayType<?, ?> arrayType) {
            return (ColumnDefinition)arrayType.walk(new ArrayType.Visitor<ColumnDefinition<?>>(){

                public ColumnDefinition<?> visit(NativeArrayType<?, ?> nativeArrayType) {
                    return ColumnDefinition.fromGenericType(name, nativeArrayType.clazz(), nativeArrayType.componentType().clazz());
                }

                public ColumnDefinition<?> visit(PrimitiveVectorType<?, ?> vectorPrimitiveType) {
                    return ColumnDefinition.ofVector(name, vectorPrimitiveType.clazz());
                }

                public ColumnDefinition<?> visit(GenericVectorType<?, ?> genericVectorType) {
                    return ColumnDefinition.fromGenericType(name, ObjectVector.class, genericVectorType.componentType().clazz());
                }
            });
        }

        public ColumnDefinition<?> visit(CustomType<?> customType) {
            return ColumnDefinition.fromGenericType(this.name, customType.clazz());
        }
    }

    public static enum ColumnType {
        Normal,
        Grouping,
        Partitioning;

    }
}

