/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table;

import io.deephaven.base.verify.Require;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.ElementSource;
import io.deephaven.engine.table.Releasable;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.TypeHelper;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.util.annotations.FinalDefault;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.jetbrains.annotations.NotNull;

public interface ColumnSource<T>
extends ChunkSource.WithPrev<Values>,
ElementSource<T>,
TupleSource<T>,
Releasable {
    public static final ColumnSource[] ZERO_LENGTH_COLUMN_SOURCE_ARRAY = new ColumnSource[0];

    public Class<T> getType();

    public Class<?> getComponentType();

    @Override
    @FinalDefault
    default public ChunkType getChunkType() {
        Class<T> dataType = this.getType();
        if (dataType == Boolean.class) {
            return ChunkType.Object;
        }
        return ChunkType.fromElementType(dataType);
    }

    public WritableRowSet match(boolean var1, boolean var2, boolean var3, @NotNull RowSet var4, Object ... var5);

    public Map<T, RowSet> getValuesMapping(RowSet var1);

    default public void startTrackingPrevValues() {
        if (!this.isImmutable()) {
            throw new UnsupportedOperationException(this.getClass().getName());
        }
    }

    public Map<T, RowSet> getGroupToRange();

    public Map<T, RowSet> getGroupToRange(RowSet var1);

    public boolean isImmutable();

    @Override
    @OverridingMethodsMustInvokeSuper
    default public void releaseCachedResources() {
        Releasable.super.releaseCachedResources();
    }

    public <ALTERNATE_DATA_TYPE> boolean allowsReinterpret(@NotNull Class<ALTERNATE_DATA_TYPE> var1);

    public <ALTERNATE_DATA_TYPE> ColumnSource<ALTERNATE_DATA_TYPE> reinterpret(@NotNull Class<ALTERNATE_DATA_TYPE> var1) throws IllegalArgumentException;

    @Override
    default public T createTuple(long rowKey) {
        return this.get(rowKey);
    }

    @Override
    default public T createPreviousTuple(long rowKey) {
        return this.getPrev(rowKey);
    }

    @Override
    default public T createTupleFromValues(Object ... values) {
        return (T)values[0];
    }

    @Override
    default public <ELEMENT_TYPE> void exportElement(T tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationIndexKey) {
        writableSource.set(destinationIndexKey, tuple);
    }

    @Override
    default public Object exportElement(T tuple, int elementIndex) {
        Require.eqZero((int)elementIndex, (String)"elementIndex");
        return tuple;
    }

    @Override
    public ColumnSource<T> getPrevSource();

    @FinalDefault
    default public <TYPE> ColumnSource<TYPE> cast(Class<? extends TYPE> clazz) {
        Require.neqNull(clazz, (String)"clazz");
        TypeHelper.checkCastTo("ColumnSource", this.getType(), clazz);
        return this;
    }

    @FinalDefault
    default public <TYPE> ColumnSource<TYPE> cast(Class<? extends TYPE> clazz, @Nullable Class<?> componentType) {
        Require.neqNull(clazz, (String)"clazz");
        TypeHelper.checkCastTo("ColumnSource", this.getType(), this.getComponentType(), clazz, componentType);
        return this;
    }

    default public boolean isStateless() {
        return true;
    }
}

