/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table;

import io.deephaven.util.datastructures.LongSizedDataStructure;

public interface DataColumn<TYPE>
extends LongSizedDataStructure {
    public String getName();

    public Class<TYPE> getType();

    public Class<?> getComponentType();

    default public Object getDirect() {
        return this.getDirect(0L, this.size());
    }

    default public Object getDirect(long startIndexInclusive, long endIndexExclusive) {
        Class<TYPE> type = this.getType();
        if (type == Byte.TYPE || type == Byte.class) {
            return this.getBytes(startIndexInclusive, endIndexExclusive);
        }
        if (type == Character.TYPE || type == Character.class) {
            return this.getChars(startIndexInclusive, endIndexExclusive);
        }
        if (type == Double.TYPE || type == Double.class) {
            return this.getDoubles(startIndexInclusive, endIndexExclusive);
        }
        if (type == Float.TYPE || type == Float.class) {
            return this.getFloats(startIndexInclusive, endIndexExclusive);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return this.getInts(startIndexInclusive, endIndexExclusive);
        }
        if (type == Long.TYPE || type == Long.class) {
            return this.getLongs(startIndexInclusive, endIndexExclusive);
        }
        if (type == Short.TYPE || type == Short.class) {
            return this.getShorts(startIndexInclusive, endIndexExclusive);
        }
        return this.get(startIndexInclusive, endIndexExclusive);
    }

    default public Object getDirect(long ... indexes) {
        Class<TYPE> type = this.getType();
        if (type == Byte.TYPE || type == Byte.class) {
            return this.getBytes(indexes);
        }
        if (type == Character.TYPE || type == Character.class) {
            return this.getChars(indexes);
        }
        if (type == Double.TYPE || type == Double.class) {
            return this.getDoubles(indexes);
        }
        if (type == Float.TYPE || type == Float.class) {
            return this.getFloats(indexes);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return this.getInts(indexes);
        }
        if (type == Long.TYPE || type == Long.class) {
            return this.getLongs(indexes);
        }
        if (type == Short.TYPE || type == Short.class) {
            return this.getShorts(indexes);
        }
        return this.get(indexes);
    }

    default public Object getDirect(int ... indexes) {
        Class<TYPE> type = this.getType();
        if (type == Byte.TYPE || type == Byte.class) {
            return this.getBytes(indexes);
        }
        if (type == Character.TYPE || type == Character.class) {
            return this.getChars(indexes);
        }
        if (type == Double.TYPE || type == Double.class) {
            return this.getDoubles(indexes);
        }
        if (type == Float.TYPE || type == Float.class) {
            return this.getFloats(indexes);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return this.getInts(indexes);
        }
        if (type == Long.TYPE || type == Long.class) {
            return this.getLongs(indexes);
        }
        if (type == Short.TYPE || type == Short.class) {
            return this.getShorts(indexes);
        }
        return this.get(indexes);
    }

    public TYPE get(long var1);

    public TYPE[] get(long var1, long var3);

    public TYPE[] get(long ... var1);

    public TYPE[] get(int ... var1);

    public Boolean getBoolean(long var1);

    public Boolean[] getBooleans(long var1, long var3);

    public Boolean[] getBooleans(long ... var1);

    public Boolean[] getBooleans(int ... var1);

    public byte getByte(long var1);

    public byte[] getBytes(long var1, long var3);

    public byte[] getBytes(long ... var1);

    public byte[] getBytes(int ... var1);

    public char getChar(long var1);

    public char[] getChars(long var1, long var3);

    public char[] getChars(long ... var1);

    public char[] getChars(int ... var1);

    public double getDouble(long var1);

    public double[] getDoubles(long var1, long var3);

    public double[] getDoubles(long ... var1);

    public double[] getDoubles(int ... var1);

    public float getFloat(long var1);

    public float[] getFloats(long var1, long var3);

    public float[] getFloats(long ... var1);

    public float[] getFloats(int ... var1);

    public int getInt(long var1);

    public int[] getInts(long var1, long var3);

    public int[] getInts(long ... var1);

    public int[] getInts(int ... var1);

    public long getLong(long var1);

    public long[] getLongs(long var1, long var3);

    public long[] getLongs(long ... var1);

    public long[] getLongs(int ... var1);

    public short getShort(long var1);

    public short[] getShorts(long var1, long var3);

    public short[] getShorts(long ... var1);

    public short[] getShorts(int ... var1);
}

