/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table;

import io.deephaven.api.JoinAddition;
import io.deephaven.api.JoinMatch;
import io.deephaven.engine.table.MultiJoinInput;
import io.deephaven.engine.table.Table;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MultiJoinInput", generator="Immutables")
@Immutable
final class ImmutableMultiJoinInput
extends MultiJoinInput {
    private final Table inputTable;
    private final JoinMatch[] columnsToMatch;
    private final JoinAddition[] columnsToAdd;

    private ImmutableMultiJoinInput(Table inputTable, JoinMatch[] columnsToMatch, JoinAddition[] columnsToAdd) {
        this.inputTable = Objects.requireNonNull(inputTable, "inputTable");
        this.columnsToMatch = (JoinMatch[])columnsToMatch.clone();
        this.columnsToAdd = (JoinAddition[])columnsToAdd.clone();
    }

    @Override
    public Table inputTable() {
        return this.inputTable;
    }

    @Override
    public JoinMatch[] columnsToMatch() {
        return (JoinMatch[])this.columnsToMatch.clone();
    }

    @Override
    public JoinAddition[] columnsToAdd() {
        return (JoinAddition[])this.columnsToAdd.clone();
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMultiJoinInput && this.equalTo(0, (ImmutableMultiJoinInput)another);
    }

    private boolean equalTo(int synthetic, ImmutableMultiJoinInput another) {
        return this.inputTable.equals(another.inputTable) && Arrays.equals(this.columnsToMatch, another.columnsToMatch) && Arrays.equals(this.columnsToAdd, another.columnsToAdd);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + this.inputTable.hashCode();
        h += (h << 5) + Arrays.hashCode(this.columnsToMatch);
        h += (h << 5) + Arrays.hashCode(this.columnsToAdd);
        return h;
    }

    public String toString() {
        return "MultiJoinInput{inputTable=" + this.inputTable + ", columnsToMatch=" + Arrays.toString(this.columnsToMatch) + ", columnsToAdd=" + Arrays.toString(this.columnsToAdd) + "}";
    }

    public static ImmutableMultiJoinInput of(Table inputTable, JoinMatch[] columnsToMatch, JoinAddition[] columnsToAdd) {
        return new ImmutableMultiJoinInput(inputTable, columnsToMatch, columnsToAdd);
    }
}

