/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table;

import com.google.common.collect.Iterators;
import gnu.trove.map.hash.TObjectIntHashMap;
import io.deephaven.base.verify.Assert;
import io.deephaven.datastructures.util.CollectionUtil;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.util.type.ArrayTypeUtils;
import java.util.BitSet;
import java.util.Map;

public class ModifiedColumnSet {
    public static final ModifiedColumnSet ALL = new ModifiedColumnSet(){

        @Override
        public Transformer newTransformer(String[] columnNames, ModifiedColumnSet[] columnSets) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BitSet extractAsBitSet() {
            throw new UnsupportedOperationException("Cannot extract BitSet when number of columns is unknown.");
        }

        @Override
        public ModifiedColumnSet copy() {
            return this;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAllDirty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean empty() {
            return false;
        }

        @Override
        public int numColumns() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAll(String[] columnNames) {
        }

        @Override
        public void setAll(ModifiedColumnSet columnSet) {
        }

        @Override
        public void setColumnWithIndex(int columnIndex) {
        }

        @Override
        public void clearAll(String[] columnNames) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clearAll(ModifiedColumnSet columnSet) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAny(ModifiedColumnSet columnSet) {
            return columnSet.size() > 0;
        }

        @Override
        public boolean containsAll(ModifiedColumnSet columnSet) {
            return columnSet.equals(this);
        }

        @Override
        public String toString() {
            return "{ALL}";
        }

        @Override
        public String toString(int maxColumns) {
            return "{ALL}";
        }
    };
    public static final ModifiedColumnSet EMPTY = new ModifiedColumnSet(){

        @Override
        public Transformer newTransformer(String[] columnNames, ModifiedColumnSet[] columnSets) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BitSet extractAsBitSet() {
            return new BitSet(0);
        }

        @Override
        public ModifiedColumnSet copy() {
            return this;
        }

        @Override
        public void clear() {
        }

        @Override
        public void setAllDirty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean empty() {
            return true;
        }

        @Override
        public int numColumns() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAll(String[] columnNames) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAll(ModifiedColumnSet columnSet) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setColumnWithIndex(int columnIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clearAll(String[] columnNames) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clearAll(ModifiedColumnSet columnSet) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAny(ModifiedColumnSet columnSet) {
            return false;
        }

        @Override
        public boolean containsAll(ModifiedColumnSet columnSet) {
            return true;
        }

        @Override
        public String toString() {
            return "{EMPTY}";
        }

        @Override
        public String toString(int maxColumns) {
            return "{EMPTY}";
        }
    };
    private final Map<String, ColumnSource<?>> columns;
    private final String[] columnNames;
    private final TObjectIntHashMap<String> idMap;
    private final BitSet dirtyColumns;

    private ModifiedColumnSet() {
        this.columns = null;
        this.columnNames = null;
        this.idMap = null;
        this.dirtyColumns = null;
    }

    public BitSet extractAsBitSet() {
        return (BitSet)this.dirtyColumns.clone();
    }

    public ModifiedColumnSet(Map<String, ColumnSource<?>> columns) {
        this.columns = columns;
        this.columnNames = columns.keySet().toArray(CollectionUtil.ZERO_LENGTH_STRING_ARRAY);
        this.idMap = new TObjectIntHashMap(this.columnNames.length, 0.5f, -1);
        for (int i = 0; i < this.columnNames.length; ++i) {
            this.idMap.put((Object)this.columnNames[i], i);
        }
        this.dirtyColumns = new BitSet(this.columnNames.length);
    }

    public ModifiedColumnSet(ModifiedColumnSet other) {
        if (other == ALL || other == EMPTY) {
            throw new IllegalArgumentException("Cannot base a new ModifiedColumnSet on ALL/EMPTY.");
        }
        this.columns = other.columns;
        this.columnNames = other.columnNames;
        this.idMap = other.idMap;
        this.dirtyColumns = new BitSet(this.columnNames.length);
    }

    public Transformer newTransformer(String[] columnNames, ModifiedColumnSet[] columnSets) {
        Assert.eq((int)columnNames.length, (String)"columnNames.length", (int)columnSets.length, (String)"columnSets.length");
        if (columnNames.length == 0) {
            return (input, output) -> {};
        }
        int[] columnBits = new int[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            int bitIndex = this.idMap.get((Object)columnNames[i]);
            if (bitIndex == this.idMap.getNoEntryValue()) {
                throw new IllegalArgumentException("Unknown column while constructing ModifiedColumnSet: " + columnNames[i]);
            }
            columnBits[i] = bitIndex;
            Assert.eq(columnSets[0].columns, (String)"columnSets[0].columns", columnSets[i].columns, (String)"columnSets[i].columns");
        }
        ModifiedColumnSet allColumns = new ModifiedColumnSet(columnSets[0]);
        for (int i = 0; i < columnNames.length; ++i) {
            allColumns.setAll(columnSets[i]);
        }
        return (input, output) -> {
            if (input == ALL) {
                output.setAll(allColumns);
                return;
            }
            this.verifyCompatibilityWith(input);
            for (int i = 0; i < columnBits.length; ++i) {
                if (!input.dirtyColumns.get(columnBits[i])) continue;
                output.setAll(columnSets[i]);
            }
        };
    }

    public Transformer newIdentityTransformer(Map<String, ? extends ColumnSource<?>> newColumns) {
        if (this.columns == newColumns) {
            throw new IllegalArgumentException("Do not use a transformer when it is correct to pass-through the ModifiedColumnSet.");
        }
        if (!Iterators.elementsEqual(this.columns.keySet().iterator(), newColumns.keySet().iterator())) {
            throw new IllegalArgumentException("Result column names are incompatible with parent column names.");
        }
        return (input, output) -> {
            if (input == ALL) {
                output.setAllDirty();
                return;
            }
            if (input.columns != this.columns || output.columns != newColumns) {
                throw new IllegalArgumentException("Provided ModifiedColumnSets are not compatible with this Transformer!");
            }
            output.dirtyColumns.or(input.dirtyColumns);
        };
    }

    public boolean isCompatibleWith(ModifiedColumnSet columnSet) {
        if (this == ALL || this == EMPTY || columnSet == ALL || columnSet == EMPTY) {
            return true;
        }
        return this.columns == columnSet.columns;
    }

    public boolean requiresTransformer(ModifiedColumnSet columnSet) {
        if (this == ALL || this == EMPTY || columnSet == ALL || columnSet == EMPTY) {
            throw new IllegalArgumentException("The ALL/EMPTY ModifiedColumnSets are not indicative of propagation compatibility.");
        }
        return this.columns != columnSet.columns;
    }

    public ModifiedColumnSet copy() {
        ModifiedColumnSet retVal = new ModifiedColumnSet(this);
        retVal.setAll(this);
        return retVal;
    }

    public void clear() {
        this.dirtyColumns.clear();
    }

    public void setAllDirty() {
        this.dirtyColumns.set(0, this.columnNames.length);
    }

    public int size() {
        return this.dirtyColumns.cardinality();
    }

    public boolean empty() {
        return this.dirtyColumns.isEmpty();
    }

    public boolean nonempty() {
        return !this.empty();
    }

    public int numColumns() {
        return this.columns.size();
    }

    public String[] dirtyColumnNames() {
        if (this.dirtyColumns == null) {
            return ArrayTypeUtils.EMPTY_STRING_ARRAY;
        }
        return (String[])this.dirtyColumns.stream().mapToObj(ci -> this.columnNames[ci]).toArray(String[]::new);
    }

    public void setAll(String ... columnNames) {
        for (String column : columnNames) {
            int bitIndex = this.idMap.get((Object)column);
            if (bitIndex == this.idMap.getNoEntryValue()) {
                throw new IllegalArgumentException("Unknown column while constructing ModifiedColumnSet: " + column);
            }
            this.dirtyColumns.set(bitIndex);
        }
    }

    public void setAll(ModifiedColumnSet columnSet) {
        if (columnSet == EMPTY) {
            return;
        }
        this.verifyCompatibilityWith(columnSet);
        if (columnSet == ALL) {
            this.dirtyColumns.set(0, this.numColumns());
        } else if (columnSet.nonempty()) {
            this.dirtyColumns.or(columnSet.dirtyColumns);
        }
    }

    public void setColumnWithIndex(int columnIndex) {
        this.dirtyColumns.set(columnIndex);
    }

    public void setColumnsInIndexRange(int columnStart, int columnEndExclusive) {
        this.dirtyColumns.set(columnStart, columnEndExclusive);
    }

    public void clearAll(String ... columnNames) {
        for (String column : columnNames) {
            int bitIndex = this.idMap.get((Object)column);
            if (bitIndex == this.idMap.getNoEntryValue()) {
                throw new IllegalArgumentException("Unknown column while constructing ModifiedColumnSet: " + column);
            }
            this.dirtyColumns.clear(bitIndex);
        }
    }

    public void clearAll(ModifiedColumnSet columnSet) {
        if (columnSet == EMPTY) {
            return;
        }
        this.verifyCompatibilityWith(columnSet);
        this.dirtyColumns.andNot(columnSet.dirtyColumns);
    }

    private void verifyCompatibilityWith(ModifiedColumnSet columnSet) {
        if (!this.isCompatibleWith(columnSet)) {
            throw new IllegalArgumentException("Provided ModifiedColumnSet is incompatible with this one! " + this.toDebugString() + " vs " + columnSet.toDebugString());
        }
    }

    public boolean containsAny(ModifiedColumnSet columnSet) {
        this.verifyCompatibilityWith(columnSet);
        if (columnSet == EMPTY) {
            return false;
        }
        return this.dirtyColumns.intersects(columnSet.dirtyColumns);
    }

    public boolean containsAll(ModifiedColumnSet columnSet) {
        this.verifyCompatibilityWith(columnSet);
        if (columnSet.empty() || this == ALL) {
            return true;
        }
        if (columnSet == ALL) {
            return this.dirtyColumns.cardinality() == this.numColumns();
        }
        BitSet copy = (BitSet)columnSet.dirtyColumns.clone();
        copy.andNot(this.dirtyColumns);
        return copy.isEmpty();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ModifiedColumnSet)) {
            return false;
        }
        ModifiedColumnSet columnSet = (ModifiedColumnSet)other;
        this.verifyCompatibilityWith(columnSet);
        if (columnSet.empty()) {
            return this.empty();
        }
        if (this == ALL || columnSet == ALL) {
            return !(columnSet != ALL && columnSet.dirtyColumns.cardinality() != columnSet.numColumns() || this != ALL && this.dirtyColumns.cardinality() != this.numColumns());
        }
        return this.dirtyColumns.equals(columnSet.dirtyColumns);
    }

    public String toDebugString() {
        if (this == EMPTY) {
            return "ModifiedColumnSet.EMPTY";
        }
        if (this == ALL) {
            return "ModifiedColumnSet.ALL";
        }
        StringBuilder sb = new StringBuilder("ModifiedColumnSet: columns=").append(Integer.toHexString(System.identityHashCode(this))).append(", {");
        for (int i = 0; i < this.columnNames.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(this.columnNames[i]);
            if (!this.dirtyColumns.get(i)) continue;
            sb.append("**");
        }
        return sb.append(" }").toString();
    }

    public String toString() {
        return this.toString(100);
    }

    public String toString(int maxColumns) {
        int count = 0;
        boolean isFirst = true;
        StringBuilder result = new StringBuilder("{");
        int i = this.dirtyColumns.nextSetBit(0);
        while (i >= 0) {
            result.append(isFirst ? "" : ",").append(this.columnNames[i]);
            isFirst = false;
            if (++count >= maxColumns) {
                result.append(",...");
                break;
            }
            i = this.dirtyColumns.nextSetBit(i + 1);
        }
        result.append("}");
        return result.toString();
    }

    public static interface Transformer {
        default public void clearAndTransform(ModifiedColumnSet input, ModifiedColumnSet output) {
            output.clear();
            this.transform(input, output);
        }

        default public void transform(ModifiedColumnSet input, ModifiedColumnSet output) {
            if (input == null || input.empty()) {
                return;
            }
            this.transformLambda(input, output);
        }

        public void transformLambda(ModifiedColumnSet var1, ModifiedColumnSet var2);
    }
}

