/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table;

import io.deephaven.engine.table.MultiJoinInput;
import io.deephaven.engine.table.MultiJoinTable;
import io.deephaven.engine.table.Table;
import java.util.ServiceLoader;
import org.jetbrains.annotations.NotNull;

public class MultiJoinFactory {
    private static Creator multiJoinTableCreator() {
        return MultiJoinTableCreatorHolder.creator;
    }

    public static MultiJoinTable of(@NotNull String[] keys, Table ... inputTables) {
        return MultiJoinFactory.multiJoinTableCreator().of(MultiJoinInput.from(keys, inputTables));
    }

    public static MultiJoinTable of(@NotNull String columnsToMatch, Table ... inputTables) {
        return MultiJoinFactory.multiJoinTableCreator().of(MultiJoinInput.from(columnsToMatch, inputTables));
    }

    public static MultiJoinTable of(MultiJoinInput ... multiJoinInputs) {
        return MultiJoinFactory.multiJoinTableCreator().of(multiJoinInputs);
    }

    private static final class MultiJoinTableCreatorHolder {
        private static final Creator creator = ServiceLoader.load(CreatorProvider.class).iterator().next().get();

        private MultiJoinTableCreatorHolder() {
        }
    }

    @FunctionalInterface
    public static interface CreatorProvider {
        public Creator get();
    }

    public static interface Creator {
        public MultiJoinTable of(MultiJoinInput ... var1);
    }
}

