/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table;

import io.deephaven.annotations.SimpleStyle;
import io.deephaven.api.JoinAddition;
import io.deephaven.api.JoinMatch;
import io.deephaven.engine.table.ImmutableMultiJoinInput;
import io.deephaven.engine.table.Table;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.immutables.value.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Value.Immutable
@SimpleStyle
public abstract class MultiJoinInput {
    public static MultiJoinInput of(@NotNull Table inputTable, @NotNull JoinMatch[] columnsToMatch, @NotNull JoinAddition[] columnsToAdd) {
        return ImmutableMultiJoinInput.of(inputTable, columnsToMatch, columnsToAdd);
    }

    public static MultiJoinInput of(@NotNull Table inputTable, @NotNull Collection<? extends JoinMatch> columnsToMatch, @NotNull Collection<? extends JoinAddition> columnsToAdd) {
        return MultiJoinInput.of(inputTable, (JoinMatch[])columnsToMatch.toArray(JoinMatch[]::new), (JoinAddition[])columnsToAdd.toArray(JoinAddition[]::new));
    }

    public static MultiJoinInput of(@NotNull Table inputTable, @NotNull String[] columnsToMatch, @NotNull String[] columnsToAdd) {
        return MultiJoinInput.of(inputTable, JoinMatch.from((String[])columnsToMatch), JoinAddition.from((String[])columnsToAdd));
    }

    public static MultiJoinInput of(@NotNull Table inputTable, String ... columnsToMatch) {
        return MultiJoinInput.of(inputTable, JoinMatch.from((String[])columnsToMatch), Collections.emptyList());
    }

    public static MultiJoinInput of(@NotNull Table inputTable, String columnsToMatch, String columnsToAdd) {
        return MultiJoinInput.of(inputTable, columnsToMatch == null || columnsToMatch.isEmpty() ? Collections.emptyList() : JoinMatch.from((String[])columnsToMatch.split(",")), columnsToAdd == null || columnsToAdd.isEmpty() ? Collections.emptyList() : JoinAddition.from((String[])columnsToAdd.split(",")));
    }

    @NotNull
    public static MultiJoinInput[] from(@NotNull String[] keys, @NotNull Table[] inputTables) {
        return (MultiJoinInput[])Arrays.stream(inputTables).map(t -> MultiJoinInput.of(t, keys)).toArray(MultiJoinInput[]::new);
    }

    @NotNull
    public static MultiJoinInput[] from(@Nullable String columnsToMatch, Table ... inputTables) {
        return (MultiJoinInput[])Arrays.stream(inputTables).map(t -> MultiJoinInput.of(t, columnsToMatch == null || columnsToMatch.isEmpty() ? Collections.emptyList() : JoinMatch.from((String[])columnsToMatch.split(",")), Collections.emptyList())).toArray(MultiJoinInput[]::new);
    }

    @Value.Parameter
    public abstract Table inputTable();

    @Value.Parameter
    public abstract JoinMatch[] columnsToMatch();

    @Value.Parameter
    public abstract JoinAddition[] columnsToAdd();
}

