/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table;

import io.deephaven.api.SortColumn;
import io.deephaven.api.TableOperations;
import io.deephaven.api.TableOperationsDefaults;
import io.deephaven.api.filter.Filter;
import io.deephaven.api.util.ConcurrentMethod;
import io.deephaven.base.log.LogOutputAppendable;
import io.deephaven.engine.context.ExecutionContext;
import io.deephaven.engine.liveness.LivenessNode;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.engine.updategraph.NotificationQueue;
import io.deephaven.util.annotations.FinalDefault;
import java.util.Collection;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PartitionedTable
extends LivenessNode,
LogOutputAppendable {
    @ConcurrentMethod
    public Table table();

    @ConcurrentMethod
    public Set<String> keyColumnNames();

    @ConcurrentMethod
    public boolean uniqueKeys();

    @ConcurrentMethod
    public String constituentColumnName();

    @ConcurrentMethod
    public TableDefinition constituentDefinition();

    @ConcurrentMethod
    public boolean constituentChangesPermitted();

    @ConcurrentMethod
    @FinalDefault
    default public Proxy proxy() {
        return this.proxy(true, true);
    }

    @ConcurrentMethod
    public Proxy proxy(boolean var1, boolean var2);

    public Table merge();

    @ConcurrentMethod
    public PartitionedTable filter(Collection<? extends Filter> var1);

    @ConcurrentMethod
    public PartitionedTable sort(Collection<SortColumn> var1);

    default public PartitionedTable transform(@NotNull UnaryOperator<Table> transformer, NotificationQueue.Dependency ... dependencies) {
        return this.transform(ExecutionContext.getContextToRecord(), transformer, this.table().isRefreshing(), dependencies);
    }

    public PartitionedTable transform(@Nullable ExecutionContext var1, @NotNull UnaryOperator<Table> var2, boolean var3, NotificationQueue.Dependency ... var4);

    default public PartitionedTable partitionedTransform(@NotNull PartitionedTable other, @NotNull BinaryOperator<Table> transformer, NotificationQueue.Dependency ... dependencies) {
        return this.partitionedTransform(other, ExecutionContext.getContextToRecord(), transformer, this.table().isRefreshing() || other.table().isRefreshing(), dependencies);
    }

    public PartitionedTable partitionedTransform(@NotNull PartitionedTable var1, @Nullable ExecutionContext var2, @NotNull BinaryOperator<Table> var3, boolean var4, NotificationQueue.Dependency ... var5);

    @ConcurrentMethod
    public Table constituentFor(Object ... var1);

    @ConcurrentMethod
    public Table[] constituents();

    public static interface Proxy
    extends TableOperationsDefaults<Proxy, TableOperations<?, ?>> {
        public PartitionedTable target();

        public boolean requiresMatchingKeys();

        public boolean sanityChecksJoins();
    }
}

