/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table;

import io.deephaven.engine.table.PartitionedTable;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.TableDefinition;
import java.util.Collection;
import java.util.ServiceLoader;
import org.jetbrains.annotations.NotNull;

public class PartitionedTableFactory {
    private static Creator partitionedTableCreator() {
        return PartitionedTableCreatorHolder.creator;
    }

    public static PartitionedTable of(@NotNull Table table, @NotNull Collection<String> keyColumnNames, boolean uniqueKeys, @NotNull String constituentColumnName, @NotNull TableDefinition constituentDefinition, boolean constituentChangesPermitted) {
        return PartitionedTableFactory.partitionedTableCreator().of(table, keyColumnNames, uniqueKeys, constituentColumnName, constituentDefinition, constituentChangesPermitted);
    }

    public static PartitionedTable of(@NotNull Table table) {
        return PartitionedTableFactory.partitionedTableCreator().of(table);
    }

    public static PartitionedTable ofTables(@NotNull TableDefinition constituentDefinition, Table ... constituents) {
        return PartitionedTableFactory.partitionedTableCreator().ofTables(constituentDefinition, constituents);
    }

    public static PartitionedTable ofTables(Table ... constituents) {
        return PartitionedTableFactory.partitionedTableCreator().ofTables(constituents);
    }

    private static final class PartitionedTableCreatorHolder {
        private static final Creator creator = ServiceLoader.load(CreatorProvider.class).iterator().next().get();

        private PartitionedTableCreatorHolder() {
        }
    }

    @FunctionalInterface
    public static interface CreatorProvider {
        public Creator get();
    }

    public static interface Creator {
        public PartitionedTable of(@NotNull Table var1, @NotNull Collection<String> var2, boolean var3, @NotNull String var4, @NotNull TableDefinition var5, boolean var6);

        public PartitionedTable of(@NotNull Table var1);

        public PartitionedTable ofTables(@NotNull TableDefinition var1, Table ... var2);

        public PartitionedTable ofTables(Table ... var1);
    }
}

