/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table;

import io.deephaven.engine.table.ResettableContext;
import io.deephaven.util.SafeCloseable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.jetbrains.annotations.NotNull;

public class SharedContext
implements ResettableContext {
    private Map<Key, ResettableContext> entries;

    protected SharedContext() {
    }

    public final <V extends ResettableContext, K extends Key<V>> V getOrCreate(K key, @NotNull Supplier<V> valueFactory) {
        if (this.entries == null) {
            this.entries = new HashMap<Key, ResettableContext>();
        }
        return (V)this.entries.computeIfAbsent(key, k -> (ResettableContext)valueFactory.get());
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void reset() {
        if (this.entries == null) {
            return;
        }
        this.entries.values().forEach(ResettableContext::reset);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void close() {
        if (this.entries == null) {
            return;
        }
        this.entries.values().forEach(SafeCloseable::close);
        this.entries.clear();
    }

    public static SharedContext makeSharedContext() {
        return new SharedContext();
    }

    public static abstract class ExactReferenceSharingKey<VALUE_TYPE extends ResettableContext>
    implements Key<VALUE_TYPE> {
        private final Object differentiator;

        protected ExactReferenceSharingKey(@NotNull Object differentiator) {
            this.differentiator = differentiator;
        }

        public final boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ExactReferenceSharingKey otherSharingKey = (ExactReferenceSharingKey)other;
            return this.differentiator == otherSharingKey.differentiator;
        }

        public final int hashCode() {
            return 31 + 31 * this.getClass().hashCode() + 31 * this.differentiator.hashCode();
        }
    }

    public static interface Key<VALUE_TYPE extends ResettableContext> {
    }
}

