/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table;

import io.deephaven.api.ColumnName;
import io.deephaven.api.Pair;
import io.deephaven.api.TableOperations;
import io.deephaven.api.agg.Aggregation;
import io.deephaven.api.util.ConcurrentMethod;
import io.deephaven.engine.liveness.LivenessNode;
import io.deephaven.engine.primitive.iterator.CloseableIterator;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfByte;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfChar;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfDouble;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfFloat;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfInt;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfLong;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfShort;
import io.deephaven.engine.rowset.TrackingRowSet;
import io.deephaven.engine.table.AttributeMap;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.GridAttributes;
import io.deephaven.engine.table.PartitionedTable;
import io.deephaven.engine.table.ShiftObliviousListener;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.engine.table.TableUpdateListener;
import io.deephaven.engine.table.WouldMatchPair;
import io.deephaven.engine.table.hierarchical.RollupTable;
import io.deephaven.engine.table.hierarchical.TreeTable;
import io.deephaven.engine.updategraph.DynamicNode;
import io.deephaven.engine.updategraph.NotificationQueue;
import io.deephaven.engine.util.systemicmarking.SystemicObject;
import io.deephaven.util.datastructures.LongSizedDataStructure;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public interface Table
extends LongSizedDataStructure,
LivenessNode,
NotificationQueue.Dependency,
DynamicNode,
SystemicObject<Table>,
TableOperations<Table, Table>,
AttributeMap<Table>,
GridAttributes<Table> {
    public static final String INPUT_TABLE_ATTRIBUTE = "InputTable";
    public static final String KEY_COLUMNS_ATTRIBUTE = "keyColumns";
    public static final String UNIQUE_KEYS_ATTRIBUTE = "uniqueKeys";
    public static final String FILTERABLE_COLUMNS_ATTRIBUTE = "FilterableColumns";
    public static final String TOTALS_TABLE_ATTRIBUTE = "TotalsTable";
    public static final String ADD_ONLY_TABLE_ATTRIBUTE = "AddOnly";
    public static final String APPEND_ONLY_TABLE_ATTRIBUTE = "AppendOnly";
    public static final String TEST_SOURCE_TABLE_ATTRIBUTE = "TestSource";
    public static final String BLINK_TABLE_ATTRIBUTE = "BlinkTable";
    public static final String SORTED_COLUMNS_ATTRIBUTE = "SortedColumns";
    public static final String SYSTEMIC_TABLE_ATTRIBUTE = "SystemicTable";
    public static final String AGGREGATION_ROW_LOOKUP_ATTRIBUTE = "AggregationRowLookup";
    public static final String SORT_REVERSE_LOOKUP_ATTRIBUTE = "SortReverseLookup";
    public static final String SNAPSHOT_VIEWPORT_TYPE = "Snapshot";
    public static final String MERGED_TABLE_ATTRIBUTE = "MergedTable";
    public static final String INITIALLY_EMPTY_COALESCED_SOURCE_TABLE_ATTRIBUTE = "EmptySourceTable";
    public static final String PREVIEW_PARENT_TABLE = "PreviewParentTable";
    public static final String NON_DISPLAY_TABLE = "NonDisplayTable";
    public static final String PLUGIN_NAME = "PluginName";
    public static final String BARRAGE_PERFORMANCE_KEY_ATTRIBUTE = "BarragePerformanceTableKey";

    @ConcurrentMethod
    public TableDefinition getDefinition();

    @ConcurrentMethod
    public Table meta();

    @ConcurrentMethod
    public String getDescription();

    @ConcurrentMethod
    public int numColumns();

    @ConcurrentMethod
    public boolean hasColumns(String ... var1);

    @ConcurrentMethod
    public boolean hasColumns(Collection<String> var1);

    @ConcurrentMethod
    public boolean isRefreshing();

    public TrackingRowSet getRowSet();

    public long sizeForInstrumentation();

    public boolean isEmpty();

    @ConcurrentMethod
    public boolean isFlat();

    public <T> ColumnSource<T> getColumnSource(String var1);

    public <T> ColumnSource<T> getColumnSource(String var1, Class<? extends T> var2);

    public <T> ColumnSource<T> getColumnSource(String var1, Class<? extends T> var2, @Nullable Class<?> var3);

    public Map<String, ? extends ColumnSource<?>> getColumnSourceMap();

    public Collection<? extends ColumnSource<?>> getColumnSources();

    public <DATA_TYPE> CloseableIterator<DATA_TYPE> columnIterator(@NotNull String var1);

    public CloseablePrimitiveIteratorOfChar characterColumnIterator(@NotNull String var1);

    public CloseablePrimitiveIteratorOfByte byteColumnIterator(@NotNull String var1);

    public CloseablePrimitiveIteratorOfShort shortColumnIterator(@NotNull String var1);

    public CloseablePrimitiveIteratorOfInt integerColumnIterator(@NotNull String var1);

    public CloseablePrimitiveIteratorOfLong longColumnIterator(@NotNull String var1);

    public CloseablePrimitiveIteratorOfFloat floatColumnIterator(@NotNull String var1);

    public CloseablePrimitiveIteratorOfDouble doubleColumnIterator(@NotNull String var1);

    public <DATA_TYPE> CloseableIterator<DATA_TYPE> objectColumnIterator(@NotNull String var1);

    @ConcurrentMethod
    public Table wouldMatch(WouldMatchPair ... var1);

    @ConcurrentMethod
    public Table wouldMatch(String ... var1);

    @ConcurrentMethod
    public Table dropColumnFormats();

    @ConcurrentMethod
    public Table renameColumns(Collection<Pair> var1);

    @ConcurrentMethod
    public Table renameColumns(String ... var1);

    @ConcurrentMethod
    public Table renameAllColumns(UnaryOperator<String> var1);

    @ConcurrentMethod
    public Table formatColumns(String ... var1);

    @ConcurrentMethod
    public Table formatRowWhere(String var1, String var2);

    @ConcurrentMethod
    public Table formatColumnWhere(String var1, String var2, String var3);

    @ConcurrentMethod
    public Table moveColumnsUp(String ... var1);

    @ConcurrentMethod
    public Table moveColumnsDown(String ... var1);

    @ConcurrentMethod
    public Table moveColumns(int var1, String ... var2);

    @ConcurrentMethod
    public Table slice(long var1, long var3);

    @ConcurrentMethod
    public Table slicePct(double var1, double var3);

    @ConcurrentMethod
    public Table headPct(double var1);

    @ConcurrentMethod
    public Table tailPct(double var1);

    public Table headBy(long var1, Collection<String> var3);

    public Table headBy(long var1, String ... var3);

    public Table tailBy(long var1, Collection<String> var3);

    public Table tailBy(long var1, String ... var3);

    @ConcurrentMethod
    public Table applyToAllBy(String var1, String var2, Collection<? extends ColumnName> var3);

    @ConcurrentMethod
    public Table applyToAllBy(String var1, Collection<? extends ColumnName> var2);

    @ConcurrentMethod
    public Table applyToAllBy(String var1, String ... var2);

    @ConcurrentMethod
    public Table removeBlink();

    @ConcurrentMethod
    public PartitionedTable partitionBy(boolean var1, String ... var2);

    @ConcurrentMethod
    public PartitionedTable partitionBy(String ... var1);

    @ConcurrentMethod
    public PartitionedTable partitionedAggBy(Collection<? extends Aggregation> var1, boolean var2, Table var3, String ... var4);

    @ConcurrentMethod
    public RollupTable rollup(Collection<? extends Aggregation> var1);

    @ConcurrentMethod
    public RollupTable rollup(Collection<? extends Aggregation> var1, boolean var2);

    @ConcurrentMethod
    public RollupTable rollup(Collection<? extends Aggregation> var1, String ... var2);

    @ConcurrentMethod
    public RollupTable rollup(Collection<? extends Aggregation> var1, boolean var2, String ... var3);

    @ConcurrentMethod
    public RollupTable rollup(Collection<? extends Aggregation> var1, Collection<? extends ColumnName> var2);

    @ConcurrentMethod
    public RollupTable rollup(Collection<? extends Aggregation> var1, boolean var2, Collection<? extends ColumnName> var3);

    @ConcurrentMethod
    public TreeTable tree(String var1, String var2);

    @ConcurrentMethod
    public Table coalesce();

    public Table getSubTable(TrackingRowSet var1);

    public <R> R apply(Function<Table, R> var1);

    @ConcurrentMethod
    public Table flatten();

    @ConcurrentMethod
    public Table withKeys(String ... var1);

    @ConcurrentMethod
    public Table withUniqueKeys(String ... var1);

    @ConcurrentMethod
    public Table setTotalsTable(String var1);

    public void close();

    public void releaseCachedResources();

    public void awaitUpdate() throws InterruptedException;

    public boolean awaitUpdate(long var1) throws InterruptedException;

    public void addUpdateListener(ShiftObliviousListener var1);

    public void addUpdateListener(ShiftObliviousListener var1, boolean var2);

    public void addUpdateListener(TableUpdateListener var1);

    public boolean addUpdateListener(TableUpdateListener var1, long var2);

    public void removeUpdateListener(ShiftObliviousListener var1);

    public void removeUpdateListener(TableUpdateListener var1);

    public boolean isFailed();
}

