/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table;

import io.deephaven.UncheckedDeephavenException;
import io.deephaven.api.ColumnName;
import io.deephaven.base.cache.OpenAddressedCanonicalizationCache;
import io.deephaven.base.log.LogOutput;
import io.deephaven.base.log.LogOutputAppendable;
import io.deephaven.base.verify.Assert;
import io.deephaven.engine.table.ColumnDefinition;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.impl.NoSuchColumnException;
import io.deephaven.io.log.impl.LogOutputStringImpl;
import io.deephaven.qst.column.header.ColumnHeader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class TableDefinition
implements LogOutputAppendable {
    private static final OpenAddressedCanonicalizationCache INTERNED_DEFINITIONS = new OpenAddressedCanonicalizationCache();
    private final List<ColumnDefinition<?>> columns;
    private int cachedHashCode;
    private Map<String, ColumnDefinition<?>> columnNameMap;

    public static TableDefinition of(ColumnDefinition<?> ... columnDefinitions) {
        return new TableDefinition(new ArrayList(Arrays.asList(columnDefinitions)));
    }

    public static TableDefinition of(Collection<ColumnDefinition<?>> columnDefinitions) {
        return new TableDefinition(new ArrayList(columnDefinitions));
    }

    public static TableDefinition inferFrom(@NotNull Map<String, ? extends ColumnSource<?>> sources) {
        ArrayList definitions = new ArrayList(sources.size());
        for (Map.Entry<String, ColumnSource<?>> e : sources.entrySet()) {
            String name = e.getKey();
            ColumnSource<?> source = e.getValue();
            ColumnDefinition<?> inferred = ColumnDefinition.fromGenericType(name, source.getType(), source.getComponentType());
            definitions.add(inferred);
        }
        return new TableDefinition(definitions);
    }

    public static TableDefinition from(@NotNull Iterable<ColumnHeader<?>> headers) {
        ArrayList definitions = new ArrayList();
        for (ColumnHeader<?> columnHeader : headers) {
            ColumnDefinition<?> columnDefinition = ColumnDefinition.from(columnHeader);
            definitions.add(columnDefinition);
        }
        return new TableDefinition(definitions);
    }

    public static TableDefinition from(@NotNull String[] columnNames, @NotNull Class<?>[] columnDataTypes) {
        if (columnNames.length != columnDataTypes.length) {
            throw new IllegalArgumentException(String.format("Input size mismatch: columnNames is of length %d, but columnDataTypes is of length %d", columnNames.length, columnDataTypes.length));
        }
        return new TableDefinition((ColumnDefinition[])IntStream.range(0, columnNames.length).mapToObj(ci -> ColumnDefinition.fromGenericType(columnNames[ci], columnDataTypes[ci])).toArray(ColumnDefinition[]::new));
    }

    public static TableDefinition from(@NotNull Iterable<String> columnNames, @NotNull Iterable<Class<?>> columnDataTypes) {
        Iterator<String> cn = columnNames.iterator();
        Iterator<Class<?>> cdt = columnDataTypes.iterator();
        ArrayList columnDefinitions = new ArrayList();
        while (cn.hasNext() && cdt.hasNext()) {
            columnDefinitions.add(ColumnDefinition.fromGenericType(cn.next(), cdt.next()));
        }
        if (cn.hasNext() || cdt.hasNext()) {
            throw new IllegalArgumentException("Input size mismatch: columnNames and columnDataTypes are not the same size");
        }
        return new TableDefinition(columnDefinitions);
    }

    private TableDefinition(@NotNull ColumnDefinition<?>[] columnDefinitions) {
        this(Arrays.asList(columnDefinitions));
    }

    private TableDefinition(@NotNull Collection<ColumnDefinition<?>> columnDefinitions) {
        ArrayList columns = new ArrayList(columnDefinitions);
        this.columns = Collections.unmodifiableList(TableDefinition.checkForNullOrDuplicates(columns));
    }

    private static List<ColumnDefinition<?>> checkForNullOrDuplicates(@NotNull List<ColumnDefinition<?>> columns) {
        if (columns.stream().anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("Supplied ColumnDefinitions include one or more null values");
        }
        HashSet columnNames = new HashSet(columns.size());
        List duplicateNames = columns.stream().map(ColumnDefinition::getName).filter(columnName -> !columnNames.add(columnName)).collect(Collectors.toList());
        if (!duplicateNames.isEmpty()) {
            throw new IllegalArgumentException("Supplied ColumnDefinitions include duplicate names " + duplicateNames);
        }
        return columns;
    }

    public TableDefinition intern() {
        return (TableDefinition)INTERNED_DEFINITIONS.getCachedItem((Object)this);
    }

    public String toString() {
        return new LogOutputStringImpl().append((LogOutputAppendable)this).toString();
    }

    public LogOutput append(@NotNull LogOutput logOutput) {
        logOutput.append((CharSequence)"TableDefinition {");
        logOutput.append((CharSequence)"columns=[");
        boolean first = true;
        for (ColumnDefinition<?> column : this.columns) {
            if (first) {
                first = false;
            } else {
                logOutput.append((CharSequence)", ");
            }
            logOutput.append(column);
        }
        logOutput.append((CharSequence)"]}");
        return logOutput;
    }

    public int numColumns() {
        return this.columns.size();
    }

    public List<ColumnDefinition<?>> getColumns() {
        return this.columns;
    }

    public ColumnDefinition<?>[] getColumnsArray() {
        return this.columns.toArray(ColumnDefinition.ZERO_LENGTH_COLUMN_DEFINITION_ARRAY);
    }

    public Stream<ColumnDefinition<?>> getColumnStream() {
        return this.columns.stream();
    }

    public Map<String, ColumnDefinition<?>> getColumnNameMap() {
        if (this.columnNameMap != null) {
            return this.columnNameMap;
        }
        this.columnNameMap = Collections.unmodifiableMap(this.getColumnStream().collect(Collectors.toMap(ColumnDefinition::getName, Function.identity(), Assert::neverInvoked, LinkedHashMap::new)));
        return this.columnNameMap;
    }

    public Set<String> getColumnNameSet() {
        return this.getColumnNameMap().keySet();
    }

    public List<ColumnDefinition<?>> getPartitioningColumns() {
        return this.getColumnStream().filter(ColumnDefinition::isPartitioning).collect(Collectors.toList());
    }

    public List<ColumnDefinition<?>> getGroupingColumns() {
        return this.getColumnStream().filter(ColumnDefinition::isGrouping).collect(Collectors.toList());
    }

    public String[] getGroupingColumnNamesArray() {
        return (String[])this.getColumnStream().filter(ColumnDefinition::isGrouping).map(ColumnDefinition::getName).toArray(String[]::new);
    }

    public List<String> getColumnNames() {
        return this.getColumnStream().map(ColumnDefinition::getName).collect(Collectors.toList());
    }

    public List<ColumnName> getTypedColumnNames() {
        return this.getColumnStream().map(ColumnDefinition::getName).map(ColumnName::of).collect(Collectors.toList());
    }

    public String[] getColumnNamesArray() {
        return (String[])this.getColumnStream().map(ColumnDefinition::getName).toArray(String[]::new);
    }

    public List<Class<?>> getColumnTypes() {
        return this.getColumnStream().map(ColumnDefinition::getDataType).collect(Collectors.toList());
    }

    public Class<?>[] getColumnTypesArray() {
        return (Class[])this.getColumnStream().map(ColumnDefinition::getDataType).toArray(Class[]::new);
    }

    public <T> ColumnDefinition<T> getColumn(@NotNull String columnName) {
        return this.getColumnNameMap().get(columnName);
    }

    public int getColumnIndex(@NotNull ColumnDefinition<?> column) {
        return this.columns.indexOf(column);
    }

    public String getColumnNamesAsString() {
        return this.getColumnStream().map(ColumnDefinition::getName).collect(Collectors.joining(","));
    }

    public final void checkHasColumn(@NotNull String columnName) {
        NoSuchColumnException.throwIf(this.getColumnNameSet(), columnName);
    }

    public final void checkHasColumn(@NotNull String columnName, @NotNull Class<?> clazz) {
        ColumnDefinition cd = this.getColumn(columnName);
        if (cd == null) {
            throw new NoSuchColumnException(this.getColumnNameSet(), columnName);
        }
        cd.checkCastTo(clazz);
    }

    public final void checkHasColumn(@NotNull String columnName, @NotNull Class<?> clazz, Class<?> componentType) {
        ColumnDefinition cd = this.getColumn(columnName);
        if (cd == null) {
            throw new NoSuchColumnException(this.getColumnNameSet(), columnName);
        }
        cd.checkCastTo(clazz, componentType);
    }

    public final void checkHasColumns(@NotNull Collection<String> columns) {
        NoSuchColumnException.throwIf(this.getColumnNameSet(), columns);
    }

    public TableDefinition checkMutualCompatibility(@NotNull TableDefinition other) {
        return this.checkMutualCompatibility(other, "this", "other");
    }

    public TableDefinition checkMutualCompatibility(@NotNull TableDefinition other, @NotNull String lhsName, @NotNull String rhsName) {
        if (this.equals(other)) {
            return this;
        }
        TableDefinition result = this.checkCompatibilityInternal(other, false);
        if (result == null || other.checkCompatibilityInternal(this, false) == null) {
            List<String> differences = this.describeCompatibilityDifferences(other, lhsName, rhsName);
            throw new IncompatibleTableDefinitionException("Table definition incompatibilities: \n\t" + String.join((CharSequence)"\n\t", differences));
        }
        return result;
    }

    public TableDefinition checkCompatibility(@NotNull TableDefinition other) {
        return this.checkCompatibility(other, false);
    }

    public TableDefinition checkCompatibility(@NotNull TableDefinition other, boolean ignorePartitioningColumns) {
        if (this.equals(other)) {
            return this;
        }
        TableDefinition minimized = this.checkCompatibilityInternal(other, ignorePartitioningColumns);
        if (minimized != null) {
            return minimized;
        }
        List<String> differences = this.describeCompatibilityDifferences(other, "this", "other");
        throw new IncompatibleTableDefinitionException("Table definition incompatibilities: " + String.join((CharSequence)"\n\t", differences));
    }

    private TableDefinition checkCompatibilityInternal(@NotNull TableDefinition other, boolean ignorePartitioningColumns) {
        ArrayList inOrder = new ArrayList();
        Map<String, ColumnDefinition<?>> myNamesToColumns = this.getColumnNameMap();
        for (ColumnDefinition<?> otherColumn : other.columns) {
            if (ignorePartitioningColumns && otherColumn.isPartitioning()) continue;
            ColumnDefinition<?> myColumn = myNamesToColumns.get(otherColumn.getName());
            if (myColumn == null) {
                return null;
            }
            if (!myColumn.isCompatible(otherColumn)) {
                return null;
            }
            inOrder.add(myColumn);
        }
        return new TableDefinition(inOrder);
    }

    public List<String> describeDifferences(@NotNull TableDefinition other, @NotNull String lhs, @NotNull String rhs) {
        return this.describeDifferences(other, lhs, rhs, ColumnDefinition::equals, true);
    }

    public List<String> describeCompatibilityDifferences(@NotNull TableDefinition other, @NotNull String lhs, @NotNull String rhs) {
        return this.describeDifferences(other, lhs, rhs, ColumnDefinition::isCompatible, false);
    }

    private List<String> describeDifferences(@NotNull TableDefinition other, @NotNull String lhs, @NotNull String rhs, @NotNull ColumnDefinitionEqualityTest test, boolean includeColumnType) {
        if (this == other) {
            return Collections.emptyList();
        }
        ArrayList<String> differences = new ArrayList<String>();
        Map<String, ColumnDefinition<?>> otherColumns = other.getColumnNameMap();
        for (ColumnDefinition<?> thisColumn : this.columns) {
            ColumnDefinition<?> otherColumn = otherColumns.get(thisColumn.getName());
            if (otherColumn == null) {
                differences.add(lhs + " column '" + thisColumn.getName() + "' is missing in " + rhs);
                continue;
            }
            if (test.match(thisColumn, otherColumn)) continue;
            differences.add("column '" + thisColumn.getName() + "' is different ...");
            thisColumn.describeDifferences(differences, otherColumn, lhs, rhs, "    " + thisColumn.getName() + ": ", includeColumnType);
        }
        Map<String, ColumnDefinition<?>> thisColumns = this.getColumnNameMap();
        for (ColumnDefinition<?> otherColumn : other.getColumns()) {
            if (null != thisColumns.get(otherColumn.getName())) continue;
            differences.add(rhs + " column '" + otherColumn.getName() + "' is missing in " + lhs);
        }
        return differences;
    }

    public String getDifferenceDescription(@NotNull TableDefinition other, @NotNull String lhs, @NotNull String rhs, @NotNull String separator) {
        List<String> differences = this.describeDifferences(other, lhs, rhs);
        return String.join((CharSequence)separator, differences);
    }

    public boolean equalsIgnoreOrder(@NotNull TableDefinition other) {
        if (this == other) {
            return true;
        }
        if (this.columns.size() != other.columns.size()) {
            return false;
        }
        Iterator thisColumns = this.getColumnStream().sorted(Comparator.comparing(ColumnDefinition::getName)).iterator();
        Iterator otherColumns = other.getColumnStream().sorted(Comparator.comparing(ColumnDefinition::getName)).iterator();
        while (thisColumns.hasNext()) {
            if (((ColumnDefinition)thisColumns.next()).equals(otherColumns.next())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TableDefinition)) {
            return false;
        }
        TableDefinition otherTD = (TableDefinition)other;
        return this.columns.equals(otherTD.columns);
    }

    public int hashCode() {
        if (this.cachedHashCode != 0) {
            return this.cachedHashCode;
        }
        int columnsHashCode = this.columns.hashCode();
        this.cachedHashCode = columnsHashCode == 0 ? 31 : columnsHashCode;
        return this.cachedHashCode;
    }

    public TableDefinition getWritable() {
        return this.getWritable(false);
    }

    public TableDefinition getWritable(boolean partitioningToNormal) {
        List<ColumnDefinition<?>> writableColumns = this.getWritableColumns(partitioningToNormal);
        if (writableColumns == this.columns) {
            return this;
        }
        return new TableDefinition(writableColumns);
    }

    private List<ColumnDefinition<?>> getWritableColumns(boolean partitioningToNormal) {
        if (this.getColumnStream().anyMatch(c -> !c.isDirect())) {
            if (partitioningToNormal) {
                return this.getColumnStream().filter(c -> c.isDirect() || c.isPartitioning()).map(c -> c.isPartitioning() ? c.withNormal() : c).collect(Collectors.toList());
            }
            return this.getColumnStream().filter(ColumnDefinition::isDirect).collect(Collectors.toList());
        }
        return this.columns;
    }

    public static class IncompatibleTableDefinitionException
    extends UncheckedDeephavenException {
        private static final long serialVersionUID = 7668080323885707687L;

        public IncompatibleTableDefinitionException() {
        }

        public IncompatibleTableDefinitionException(String message) {
            super(message);
        }

        public IncompatibleTableDefinitionException(String message, Throwable cause) {
            super(message, cause);
        }

        public IncompatibleTableDefinitionException(Throwable cause) {
            super(cause);
        }
    }

    @FunctionalInterface
    private static interface ColumnDefinitionEqualityTest {
        public boolean match(ColumnDefinition<?> var1, ColumnDefinition<?> var2);
    }
}

