/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table;

import io.deephaven.engine.table.Table;
import io.deephaven.qst.TableCreator;
import io.deephaven.qst.column.Column;
import io.deephaven.qst.table.EmptyTable;
import io.deephaven.qst.table.NewTable;
import io.deephaven.qst.table.TicketTable;
import io.deephaven.qst.table.TimeTable;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.ServiceLoader;
import java.util.stream.Stream;

public class TableFactory {
    private static TableCreator<Table> tableCreator() {
        return TableCreatorHolder.tableCreator;
    }

    public static Table of(NewTable newTable) {
        return (Table)TableFactory.tableCreator().of(newTable);
    }

    public static Table of(EmptyTable emptyTable) {
        return (Table)TableFactory.tableCreator().of(emptyTable);
    }

    public static Table of(TimeTable timeTable) {
        return (Table)TableFactory.tableCreator().of(timeTable);
    }

    public static Table of(TicketTable ticketTable) {
        return (Table)TableFactory.tableCreator().of(ticketTable);
    }

    public static Table merge(Iterable<Table> tables) {
        return (Table)TableFactory.tableCreator().merge(tables);
    }

    public static Table emptyTable(long size) {
        return TableFactory.of(EmptyTable.of((long)size));
    }

    public static Table newTable(Column<?> ... columns) {
        return TableFactory.of(NewTable.of(columns));
    }

    public static Table newTable(Iterable<Column<?>> columns) {
        return TableFactory.of(NewTable.of(columns));
    }

    public static Table timeTable(Duration interval) {
        return TableFactory.of(TimeTable.of((Duration)interval));
    }

    public static Table timeTable(Duration interval, Instant startTime) {
        return TableFactory.of(TimeTable.of((Duration)interval, (Instant)startTime));
    }

    public static Table merge(Table t1, Table t2) {
        return TableFactory.merge(Arrays.asList(t1, t2));
    }

    public static Table merge(Table t1, Table t2, Table t3) {
        return TableFactory.merge(Arrays.asList(t1, t2, t3));
    }

    public static Table merge(Table t1, Table t2, Table t3, Table t4) {
        return TableFactory.merge(Arrays.asList(t1, t2, t3, t4));
    }

    public static Table merge(Table t1, Table t2, Table t3, Table t4, Table t5) {
        return TableFactory.merge(Arrays.asList(t1, t2, t3, t4, t5));
    }

    public static Table merge(Table t1, Table t2, Table t3, Table t4, Table t5, Table t6) {
        return TableFactory.merge(Arrays.asList(t1, t2, t3, t4, t5, t6));
    }

    public static Table merge(Table t1, Table t2, Table t3, Table t4, Table t5, Table t6, Table t7) {
        return TableFactory.merge(Arrays.asList(t1, t2, t3, t4, t5, t6, t7));
    }

    public static Table merge(Table t1, Table t2, Table t3, Table t4, Table t5, Table t6, Table t7, Table t8) {
        return TableFactory.merge(Arrays.asList(t1, t2, t3, t4, t5, t6, t7, t8));
    }

    public static Table merge(Table t1, Table t2, Table t3, Table t4, Table t5, Table t6, Table t7, Table t8, Table t9) {
        return TableFactory.merge(Arrays.asList(t1, t2, t3, t4, t5, t6, t7, t8, t9));
    }

    public static Table merge(Table t1, Table t2, Table t3, Table t4, Table t5, Table t6, Table t7, Table t8, Table t9, Table ... remaining) {
        return TableFactory.merge(() -> Stream.concat(Stream.of(t1, t2, t3, t4, t5, t6, t7, t8, t9), Stream.of(remaining)).iterator());
    }

    public static Table merge(Table[] tables) {
        return TableFactory.merge(Arrays.asList(tables));
    }

    public static Table ticket(String ticket) {
        return TableFactory.of(TicketTable.of((String)ticket));
    }

    public static Table ticket(byte[] ticket) {
        return TableFactory.of(TicketTable.of((byte[])ticket));
    }

    private static final class TableCreatorHolder {
        private static final TableCreator<Table> tableCreator = ServiceLoader.load(TableCreatorProvider.class).iterator().next().get();

        private TableCreatorHolder() {
        }
    }

    @FunctionalInterface
    public static interface TableCreatorProvider {
        public TableCreator<Table> get();
    }
}

