/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table;

import io.deephaven.base.log.LogOutput;
import io.deephaven.base.log.LogOutputAppendable;
import io.deephaven.base.verify.Assert;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetShiftData;
import io.deephaven.engine.table.ModifiedColumnSet;
import java.util.function.BiConsumer;

public interface TableUpdate
extends LogOutputAppendable {
    default public LogOutput append(LogOutput logOutput) {
        return logOutput.append('{').append((CharSequence)"added=").append((LogOutputAppendable)this.added()).append((CharSequence)", removed=").append((LogOutputAppendable)this.removed()).append((CharSequence)", modified=").append((LogOutputAppendable)this.modified()).append((CharSequence)", shifted=").append((CharSequence)(this.shifted() == null ? "{}" : this.shifted().toString())).append((CharSequence)", modifiedColumnSet=").append((CharSequence)(this.modifiedColumnSet() == null ? "{EMPTY}" : this.modifiedColumnSet().toString())).append((CharSequence)"}");
    }

    public TableUpdate acquire();

    public void release();

    default public boolean empty() {
        return this.added().isEmpty() && this.removed().isEmpty() && this.modified().isEmpty() && this.shifted().empty();
    }

    default public boolean valid() {
        return this.added() != null && this.removed() != null && this.modified() != null && this.shifted() != null && this.modifiedColumnSet() != null;
    }

    public RowSet getModifiedPreShift();

    default public void forAllModified(BiConsumer<Long, Long> consumer) {
        RowSet prevModified = this.getModifiedPreShift();
        RowSet.Iterator it = this.modified().iterator();
        RowSet.Iterator pit = prevModified.iterator();
        while (it.hasNext() && pit.hasNext()) {
            consumer.accept(pit.nextLong(), it.next());
        }
        Assert.assertion((!it.hasNext() ? 1 : 0) != 0, (String)"!it.hasNext()");
        Assert.assertion((!pit.hasNext() ? 1 : 0) != 0, (String)"!pit.hasNext()");
    }

    public RowSet added();

    public RowSet removed();

    public RowSet modified();

    public RowSetShiftData shifted();

    public ModifiedColumnSet modifiedColumnSet();
}

