/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table;

class TypeHelper {
    TypeHelper() {
    }

    public static void checkCastTo(String context, Class<?> srcType, Class<?> destType) {
        if (!destType.isAssignableFrom(srcType)) {
            throw new ClassCastException(String.format("Cannot convert %s of type %s to type %s", context, srcType.getName(), destType.getName()));
        }
    }

    public static void checkCastTo(String prefix, Class<?> srcType, Class<?> srcComponentType, Class<?> destType, Class<?> destComponentType) {
        TypeHelper.checkCastTo(prefix, srcType, destType);
        if (srcComponentType == null && destComponentType == null || srcComponentType != null && destComponentType != null && destComponentType.isAssignableFrom(srcComponentType)) {
            return;
        }
        throw new ClassCastException(String.format("Cannot convert %s componentType of type %s to %s (for %s / %s)", prefix, srcComponentType == null ? null : srcComponentType.getName(), destComponentType == null ? null : destComponentType.getName(), srcType.getName(), destType.getName()));
    }
}

