/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table;

import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.FloatChunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.chunkattributes.RowKeys;
import io.deephaven.engine.table.ChunkSink;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.util.annotations.FinalDefault;
import io.deephaven.util.datastructures.LongAbortableConsumer;
import org.jetbrains.annotations.NotNull;

public interface WritableColumnSource<T>
extends ColumnSource<T>,
ChunkSink<Values> {
    default public void set(long key, T value) {
        throw new UnsupportedOperationException();
    }

    default public void set(long key, byte value) {
        throw new UnsupportedOperationException();
    }

    default public void set(long key, char value) {
        throw new UnsupportedOperationException();
    }

    default public void set(long key, double value) {
        throw new UnsupportedOperationException();
    }

    default public void set(long key, float value) {
        throw new UnsupportedOperationException();
    }

    default public void set(long key, int value) {
        throw new UnsupportedOperationException();
    }

    default public void set(long key, long value) {
        throw new UnsupportedOperationException();
    }

    default public void set(long key, short value) {
        throw new UnsupportedOperationException();
    }

    public void setNull(long var1);

    default public void setNull(RowSequence orderedKeys) {
        orderedKeys.forAllRowKeys(this::setNull);
    }

    @FinalDefault
    default public void ensureCapacity(long capacity) {
        this.ensureCapacity(capacity, true);
    }

    public void ensureCapacity(long var1, boolean var3);

    @Override
    default public ChunkSink.FillFromContext makeFillFromContext(int chunkCapacity) {
        return SinkFiller.create(this.getChunkType());
    }

    @Override
    default public void fillFromChunk(@NotNull ChunkSink.FillFromContext context, @NotNull Chunk<? extends Values> src, @NotNull RowSequence rowSequence) {
        SinkFiller filler = (SinkFiller)context;
        filler.reset(this, src);
        rowSequence.forEachRowKey((LongAbortableConsumer)filler);
    }

    @Override
    default public void fillFromChunkUnordered(@NotNull ChunkSink.FillFromContext context, @NotNull Chunk<? extends Values> src, @NotNull LongChunk<RowKeys> keys) {
        SinkFiller filler = (SinkFiller)context;
        filler.reset(this, src);
        for (int ii = 0; ii < keys.size(); ++ii) {
            filler.accept(keys.get(ii));
        }
    }

    public static class ObjectFiller
    extends SinkFiller {
        private ObjectChunk<?, ? extends Values> typedSrc;

        @Override
        final void resetSrc(Chunk<? extends Values> src) {
            this.typedSrc = src.asObjectChunk();
        }

        public final boolean accept(long v) {
            this.dest.set(v, this.typedSrc.get(this.srcIndex++));
            return true;
        }
    }

    public static class ShortFiller
    extends SinkFiller {
        private ShortChunk<? extends Values> typedSrc;

        @Override
        final void resetSrc(Chunk<? extends Values> src) {
            this.typedSrc = src.asShortChunk();
        }

        public final boolean accept(long v) {
            this.dest.set(v, this.typedSrc.get(this.srcIndex++));
            return true;
        }
    }

    public static class LongFiller
    extends SinkFiller {
        private LongChunk<? extends Values> typedSrc;

        @Override
        final void resetSrc(Chunk<? extends Values> src) {
            this.typedSrc = src.asLongChunk();
        }

        public final boolean accept(long v) {
            this.dest.set(v, this.typedSrc.get(this.srcIndex++));
            return true;
        }
    }

    public static class IntFiller
    extends SinkFiller {
        private IntChunk<? extends Values> typedSrc;

        @Override
        final void resetSrc(Chunk<? extends Values> src) {
            this.typedSrc = src.asIntChunk();
        }

        public final boolean accept(long v) {
            this.dest.set(v, this.typedSrc.get(this.srcIndex++));
            return true;
        }
    }

    public static class FloatFiller
    extends SinkFiller {
        private FloatChunk<? extends Values> typedSrc;

        @Override
        final void resetSrc(Chunk<? extends Values> src) {
            this.typedSrc = src.asFloatChunk();
        }

        public final boolean accept(long v) {
            this.dest.set(v, this.typedSrc.get(this.srcIndex++));
            return true;
        }
    }

    public static class DoubleFiller
    extends SinkFiller {
        private DoubleChunk<? extends Values> typedSrc;

        @Override
        final void resetSrc(Chunk<? extends Values> src) {
            this.typedSrc = src.asDoubleChunk();
        }

        public final boolean accept(long v) {
            this.dest.set(v, this.typedSrc.get(this.srcIndex++));
            return true;
        }
    }

    public static class CharFiller
    extends SinkFiller {
        private CharChunk<? extends Values> typedSrc;

        @Override
        final void resetSrc(Chunk<? extends Values> src) {
            this.typedSrc = src.asCharChunk();
        }

        public final boolean accept(long v) {
            this.dest.set(v, this.typedSrc.get(this.srcIndex++));
            return true;
        }
    }

    public static class ByteFiller
    extends SinkFiller {
        private ByteChunk<? extends Values> typedSrc;

        @Override
        final void resetSrc(Chunk<? extends Values> src) {
            this.typedSrc = src.asByteChunk();
        }

        public final boolean accept(long v) {
            this.dest.set(v, this.typedSrc.get(this.srcIndex++));
            return true;
        }
    }

    public static abstract class SinkFiller
    implements ChunkSink.FillFromContext,
    LongAbortableConsumer {
        WritableColumnSource dest;
        int srcIndex;

        public static SinkFiller create(ChunkType chunkType) {
            switch (chunkType) {
                case Byte: {
                    return new ByteFiller();
                }
                case Char: {
                    return new CharFiller();
                }
                case Double: {
                    return new DoubleFiller();
                }
                case Float: {
                    return new FloatFiller();
                }
                case Int: {
                    return new IntFiller();
                }
                case Long: {
                    return new LongFiller();
                }
                case Short: {
                    return new ShortFiller();
                }
                case Object: {
                    return new ObjectFiller();
                }
            }
            throw new UnsupportedOperationException("Unexpected chunkType " + chunkType);
        }

        final void reset(WritableColumnSource dest, Chunk<? extends Values> src) {
            this.dest = dest;
            this.srcIndex = 0;
            this.resetSrc(src);
        }

        abstract void resetSrc(Chunk<? extends Values> var1);
    }
}

