/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table;

import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.WritableColumnSource;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public interface WritableSourceWithPrepareForParallelPopulation {
    public static boolean supportsParallelPopulation(WritableColumnSource<?> wcs) {
        return wcs instanceof WritableSourceWithPrepareForParallelPopulation;
    }

    public void prepareForParallelPopulation(RowSequence var1);

    public static boolean allSupportParallelPopulation(WritableColumnSource<?> ... sources) {
        return Arrays.stream(sources).allMatch(WritableSourceWithPrepareForParallelPopulation::supportsParallelPopulation);
    }

    public static void prepareAll(@NotNull RowSequence rowSequence, WritableColumnSource<?> ... sources) {
        for (WritableColumnSource<?> source : sources) {
            if (!WritableSourceWithPrepareForParallelPopulation.supportsParallelPopulation(source)) {
                throw new IllegalArgumentException(String.format("WritableColumnSource implementation %s does not support parallel population", source.getClass()));
            }
            ((WritableSourceWithPrepareForParallelPopulation)((Object)source)).prepareForParallelPopulation(rowSequence);
        }
    }
}

