/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.hierarchical;

import io.deephaven.api.ColumnName;
import io.deephaven.api.agg.Aggregation;
import io.deephaven.api.filter.Filter;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.engine.table.hierarchical.FormatOperationsRecorder;
import io.deephaven.engine.table.hierarchical.HierarchicalTable;
import io.deephaven.engine.table.hierarchical.SortOperationsRecorder;
import io.deephaven.util.annotations.FinalDefault;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public interface RollupTable
extends HierarchicalTable<RollupTable> {
    public Collection<? extends Aggregation> getAggregations();

    public boolean includesConstituents();

    @FinalDefault
    default public NodeType getLeafNodeType() {
        return this.includesConstituents() ? NodeType.Constituent : NodeType.Aggregated;
    }

    public Collection<? extends ColumnName> getGroupByColumns();

    public TableDefinition getNodeDefinition(@NotNull NodeType var1);

    public RollupTable withFilter(Filter var1);

    public NodeOperationsRecorder makeNodeOperationsRecorder(@NotNull NodeType var1);

    public RollupTable withNodeOperations(NodeOperationsRecorder ... var1);

    public NodeOperationsRecorder translateAggregatedNodeOperationsForConstituentNodes(@NotNull NodeOperationsRecorder var1);

    public static interface NodeOperationsRecorder
    extends FormatOperationsRecorder<NodeOperationsRecorder>,
    SortOperationsRecorder<NodeOperationsRecorder> {
        public boolean isEmpty();
    }

    public static enum NodeType {
        Aggregated,
        Constituent;

    }
}

