/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.hierarchical;

import io.deephaven.api.ColumnName;
import io.deephaven.api.JoinAddition;
import io.deephaven.api.JoinMatch;
import io.deephaven.api.RawString;
import io.deephaven.api.Selectable;
import io.deephaven.api.expression.Expression;
import io.deephaven.api.filter.Filter;
import io.deephaven.engine.liveness.LivenessScopeStack;
import io.deephaven.engine.table.ColumnDefinition;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.engine.table.hierarchical.FilterOperationsRecorder;
import io.deephaven.engine.table.hierarchical.FormatOperationsRecorder;
import io.deephaven.engine.table.hierarchical.HierarchicalTable;
import io.deephaven.engine.table.hierarchical.SortOperationsRecorder;
import io.deephaven.engine.updategraph.DynamicNode;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface TreeTable
extends HierarchicalTable<TreeTable> {
    public ColumnName getIdentifierColumn();

    public ColumnName getParentIdentifierColumn();

    public TableDefinition getNodeDefinition();

    public TreeTable withNodeFilterColumns(@NotNull Collection<? extends ColumnName> var1);

    public TreeTable withFilter(@NotNull Filter var1);

    public NodeOperationsRecorder makeNodeOperationsRecorder();

    public TreeTable withNodeOperations(@NotNull NodeOperationsRecorder var1);

    public static Table promoteOrphans(@NotNull Table source, @NotNull String idColumn, @NotNull String parentColumn) {
        ColumnName parent = ColumnName.of((String)parentColumn);
        ColumnName identifier = ColumnName.of((String)idColumn);
        ColumnName sentinel = ColumnName.of((String)"__MATCHED_PARENT_IDENTIFIER__");
        Selectable[] viewColumns = (Selectable[])source.getDefinition().getColumnStream().map(ColumnDefinition::getName).map(columnName -> columnName.equals(parent.name()) ? Selectable.of((ColumnName)parent, (Expression)RawString.of((String)("isNull(" + sentinel.name() + ") ? null : " + parent.name()))) : ColumnName.of((String)columnName)).toArray(Selectable[]::new);
        return (Table)LivenessScopeStack.computeEnclosed(() -> (Table)((Table)source.naturalJoin(source, List.of(JoinMatch.of((ColumnName)parent, (ColumnName)identifier)), List.of(JoinAddition.of((ColumnName)sentinel, (ColumnName)identifier)))).view(List.of(viewColumns)), source::isRefreshing, DynamicNode::isRefreshing);
    }

    public static interface NodeOperationsRecorder
    extends FormatOperationsRecorder<NodeOperationsRecorder>,
    SortOperationsRecorder<NodeOperationsRecorder>,
    FilterOperationsRecorder<NodeOperationsRecorder> {
        public boolean isEmpty();
    }
}

