/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class NoSuchColumnException
extends IllegalArgumentException {
    public static final String DELIMITER = ", ";
    public static final String DEFAULT_FORMAT_STR = "Unknown column names [%s], available column names are [%s]";

    public static void throwIf(Set<String> available, String requested) {
        NoSuchColumnException.throwIf(available, Collections.singleton(requested));
    }

    public static void throwIf(Set<String> available, Collection<String> requested) {
        NoSuchColumnException.throwIf(available, requested, DEFAULT_FORMAT_STR, Type.MISSING, Type.AVAILABLE);
    }

    public static void throwIf(Set<String> available, Collection<String> requested, String formatStr, Type ... types) {
        List missing = requested.stream().filter(Predicate.not(available::contains)).collect(Collectors.toList());
        if (!missing.isEmpty()) {
            Object[] formatArgs = new Object[types.length];
            block5: for (int i = 0; i < types.length; ++i) {
                switch (types[i]) {
                    case MISSING: {
                        formatArgs[i] = String.join((CharSequence)DELIMITER, missing);
                        continue block5;
                    }
                    case AVAILABLE: {
                        formatArgs[i] = String.join((CharSequence)DELIMITER, available);
                        continue block5;
                    }
                    case REQUESTED: {
                        formatArgs[i] = String.join((CharSequence)DELIMITER, requested);
                        continue block5;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected case " + types[i]);
                    }
                }
            }
            throw new NoSuchColumnException(String.format(formatStr, formatArgs));
        }
    }

    public NoSuchColumnException(String message) {
        super(message);
    }

    public NoSuchColumnException(Collection<String> presentColumns, Collection<String> missingColumns) {
        this(String.format(DEFAULT_FORMAT_STR, String.join((CharSequence)DELIMITER, missingColumns), String.join((CharSequence)DELIMITER, presentColumns)));
    }

    public NoSuchColumnException(Collection<String> presentColumns, String missingColumn) {
        this(presentColumns, Collections.singleton(missingColumn));
    }

    public static enum Type {
        MISSING,
        AVAILABLE,
        REQUESTED;

    }
}

