/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.iterators;

import io.deephaven.engine.primitive.function.ByteToIntFunction;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfByte;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfInt;
import io.deephaven.engine.table.iterators.ColumnIterator;
import io.deephaven.util.annotations.FinalDefault;
import io.deephaven.util.type.TypeUtils;
import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;

public interface ByteColumnIterator
extends ColumnIterator<Byte>,
CloseablePrimitiveIteratorOfByte {
    @FinalDefault
    default public Byte next() {
        return TypeUtils.box((byte)this.nextByte());
    }

    @FinalDefault
    default public void forEachRemaining(@NotNull Consumer<? super Byte> action) {
        this.forEachRemaining(element -> action.accept(TypeUtils.box((byte)element)));
    }

    @FinalDefault
    default public IntStream streamAsInt(@NotNull ByteToIntFunction adapter) {
        CloseablePrimitiveIteratorOfInt adapted = this.adaptToOfInt(adapter);
        return (IntStream)StreamSupport.intStream(Spliterators.spliterator((PrimitiveIterator.OfInt)adapted, this.remaining(), 1040), false).onClose(() -> ((ByteColumnIterator)this).close());
    }

    @FinalDefault
    default public IntStream streamAsInt() {
        return this.streamAsInt(value -> value == -128 ? Integer.MIN_VALUE : (int)value);
    }

    @FinalDefault
    default public Stream<Byte> stream() {
        return (Stream)StreamSupport.stream(Spliterators.spliterator(this, this.remaining(), 1040), false).onClose(() -> ((ByteColumnIterator)this).close());
    }
}

