/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.iterators;

import io.deephaven.engine.primitive.function.CharToIntFunction;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfChar;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfInt;
import io.deephaven.engine.table.iterators.ColumnIterator;
import io.deephaven.util.annotations.FinalDefault;
import io.deephaven.util.type.TypeUtils;
import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;

public interface CharacterColumnIterator
extends ColumnIterator<Character>,
CloseablePrimitiveIteratorOfChar {
    @FinalDefault
    default public Character next() {
        return TypeUtils.box((char)this.nextChar());
    }

    @FinalDefault
    default public void forEachRemaining(@NotNull Consumer<? super Character> action) {
        this.forEachRemaining(element -> action.accept(TypeUtils.box((char)element)));
    }

    @FinalDefault
    default public IntStream streamAsInt(@NotNull CharToIntFunction adapter) {
        CloseablePrimitiveIteratorOfInt adapted = this.adaptToOfInt(adapter);
        return (IntStream)StreamSupport.intStream(Spliterators.spliterator((PrimitiveIterator.OfInt)adapted, this.remaining(), 1040), false).onClose(() -> ((CharacterColumnIterator)this).close());
    }

    @FinalDefault
    default public IntStream streamAsInt() {
        return this.streamAsInt(value -> value == '\uffff' ? Integer.MIN_VALUE : (int)value);
    }

    @FinalDefault
    default public Stream<Character> stream() {
        return (Stream)StreamSupport.stream(Spliterators.spliterator(this, this.remaining(), 1040), false).onClose(() -> ((CharacterColumnIterator)this).close());
    }
}

