/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.iterators;

import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.engine.primitive.function.ByteConsumer;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.iterators.ByteColumnIterator;
import io.deephaven.engine.table.iterators.ChunkedColumnIterator;
import org.jetbrains.annotations.NotNull;

public final class ChunkedByteColumnIterator
extends ChunkedColumnIterator<Byte, ByteChunk<? extends Any>>
implements ByteColumnIterator {
    public ChunkedByteColumnIterator(@NotNull ChunkSource<? extends Any> chunkSource, @NotNull RowSequence rowSequence, int chunkSize, long firstRowKey, long length) {
        super(ChunkedByteColumnIterator.validateChunkType(chunkSource, ChunkType.Byte), rowSequence, chunkSize, firstRowKey, length);
    }

    public ChunkedByteColumnIterator(@NotNull ChunkSource<? extends Any> chunkSource, @NotNull RowSequence rowSequence) {
        this(chunkSource, rowSequence, 2048, rowSequence.firstRowKey(), rowSequence.size());
    }

    @Override
    ByteChunk<? extends Any> castChunk(@NotNull Chunk<? extends Any> chunk) {
        return chunk.asByteChunk();
    }

    public byte nextByte() {
        this.maybeAdvance();
        return ((ByteChunk)this.currentData).get(this.currentOffset++);
    }

    public void forEachRemaining(@NotNull ByteConsumer action) {
        this.consumeRemainingByChunks(() -> {
            int currentSize = ((ByteChunk)this.currentData).size();
            while (this.currentOffset < currentSize) {
                action.accept(((ByteChunk)this.currentData).get(this.currentOffset++));
            }
        });
    }
}

