/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.iterators;

import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.engine.primitive.function.CharConsumer;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.iterators.CharacterColumnIterator;
import io.deephaven.engine.table.iterators.ChunkedColumnIterator;
import org.jetbrains.annotations.NotNull;

public final class ChunkedCharacterColumnIterator
extends ChunkedColumnIterator<Character, CharChunk<? extends Any>>
implements CharacterColumnIterator {
    public ChunkedCharacterColumnIterator(@NotNull ChunkSource<? extends Any> chunkSource, @NotNull RowSequence rowSequence, int chunkSize, long firstRowKey, long length) {
        super(ChunkedCharacterColumnIterator.validateChunkType(chunkSource, ChunkType.Char), rowSequence, chunkSize, firstRowKey, length);
    }

    public ChunkedCharacterColumnIterator(@NotNull ChunkSource<? extends Any> chunkSource, @NotNull RowSequence rowSequence) {
        this(chunkSource, rowSequence, 2048, rowSequence.firstRowKey(), rowSequence.size());
    }

    @Override
    CharChunk<? extends Any> castChunk(@NotNull Chunk<? extends Any> chunk) {
        return chunk.asCharChunk();
    }

    public char nextChar() {
        this.maybeAdvance();
        return ((CharChunk)this.currentData).get(this.currentOffset++);
    }

    public void forEachRemaining(@NotNull CharConsumer action) {
        this.consumeRemainingByChunks(() -> {
            int currentSize = ((CharChunk)this.currentData).size();
            while (this.currentOffset < currentSize) {
                action.accept(((CharChunk)this.currentData).get(this.currentOffset++));
            }
        });
    }
}

