/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.iterators;

import io.deephaven.base.verify.Require;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.iterators.ChunkedByteColumnIterator;
import io.deephaven.engine.table.iterators.ChunkedCharacterColumnIterator;
import io.deephaven.engine.table.iterators.ChunkedDoubleColumnIterator;
import io.deephaven.engine.table.iterators.ChunkedFloatColumnIterator;
import io.deephaven.engine.table.iterators.ChunkedIntegerColumnIterator;
import io.deephaven.engine.table.iterators.ChunkedLongColumnIterator;
import io.deephaven.engine.table.iterators.ChunkedObjectColumnIterator;
import io.deephaven.engine.table.iterators.ChunkedShortColumnIterator;
import io.deephaven.engine.table.iterators.ColumnIterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public abstract class ChunkedColumnIterator<DATA_TYPE, CHUNK_TYPE extends Chunk<? extends Any>>
implements ColumnIterator<DATA_TYPE> {
    public static final int DEFAULT_CHUNK_SIZE = 2048;
    private final int chunkSize;
    private ChunkSource<? extends Any> chunkSource;
    private ChunkSource.GetContext getContext;
    private RowSequence.Iterator rowKeyIterator;
    private long remainingRowKeys;
    CHUNK_TYPE currentData;
    int currentOffset;

    ChunkedColumnIterator(@NotNull ChunkSource<? extends Any> chunkSource, @NotNull RowSequence rowSequence, int chunkSize, long firstRowKey, long length) {
        this.chunkSize = Require.gtZero((int)chunkSize, (String)"chunkSize");
        this.chunkSource = chunkSource;
        this.getContext = chunkSource.makeGetContext(chunkSize);
        this.rowKeyIterator = rowSequence.getRowSequenceIterator();
        long consumed = this.rowKeyIterator.advanceAndGetPositionDistance(firstRowKey);
        if (this.rowKeyIterator.peekNextKey() != firstRowKey) {
            throw new IllegalArgumentException(String.format("Invalid first row key %d, not present in iteration row sequence", firstRowKey));
        }
        if (rowSequence.size() - consumed < length) {
            throw new IllegalArgumentException(String.format("Invalid length %d, iteration row sequence only contains %d rows (%d already consumed)", length, rowSequence.size(), consumed));
        }
        this.remainingRowKeys = length;
        this.currentData = null;
        this.currentOffset = Integer.MAX_VALUE;
    }

    static ChunkSource<? extends Any> validateChunkType(@NotNull ChunkSource<? extends Any> chunkSource, @NotNull ChunkType expectedChunkType) {
        ChunkType chunkType = chunkSource.getChunkType();
        if (chunkType != expectedChunkType) {
            throw new IllegalArgumentException("Illegal chunk type " + chunkType + ", expected " + expectedChunkType);
        }
        return chunkSource;
    }

    @Override
    public final long remaining() {
        return this.remainingRowKeys + (long)(this.currentData == null ? 0 : this.currentData.size() - this.currentOffset);
    }

    public final boolean hasNext() {
        if ((this.currentData == null || this.currentOffset >= this.currentData.size()) && this.remainingRowKeys <= 0L) {
            this.close();
            return false;
        }
        return true;
    }

    final void maybeAdvance() {
        if (this.currentData == null || this.currentOffset >= this.currentData.size()) {
            if (this.remainingRowKeys <= 0L) {
                this.close();
                throw new NoSuchElementException();
            }
            RowSequence currentRowKeys = this.rowKeyIterator.getNextRowSequenceWithLength(Math.min((long)this.chunkSize, this.remainingRowKeys));
            this.remainingRowKeys -= currentRowKeys.size();
            this.currentData = this.castChunk(this.chunkSource.getChunk(this.getContext, currentRowKeys));
            this.currentOffset = 0;
        }
    }

    abstract CHUNK_TYPE castChunk(@NotNull Chunk<? extends Any> var1);

    final void consumeRemainingByChunks(@NotNull Runnable consumeCurrentChunk) {
        while (this.hasNext()) {
            this.maybeAdvance();
            consumeCurrentChunk.run();
        }
    }

    public final void close() {
        try (ChunkSource.GetContext ignored1 = this.getContext;
             RowSequence.Iterator ignored2 = this.rowKeyIterator;){
            this.chunkSource = null;
            this.getContext = null;
            this.rowKeyIterator = null;
            this.remainingRowKeys = 0L;
            this.currentData = null;
            this.currentOffset = Integer.MAX_VALUE;
        }
    }

    public static <DATA_TYPE> ColumnIterator<DATA_TYPE> make(@NotNull ChunkSource<? extends Any> chunkSource, @NotNull RowSequence rowSequence) {
        return ChunkedColumnIterator.make(chunkSource, rowSequence, 2048);
    }

    public static <DATA_TYPE> ColumnIterator<DATA_TYPE> make(@NotNull ChunkSource<? extends Any> chunkSource, @NotNull RowSequence rowSequence, int chunkSize) {
        ChunkedColumnIterator result;
        switch (chunkSource.getChunkType()) {
            case Char: {
                result = new ChunkedCharacterColumnIterator(chunkSource, rowSequence, chunkSize, rowSequence.firstRowKey(), rowSequence.size());
                break;
            }
            case Byte: {
                result = new ChunkedByteColumnIterator(chunkSource, rowSequence, chunkSize, rowSequence.firstRowKey(), rowSequence.size());
                break;
            }
            case Short: {
                result = new ChunkedShortColumnIterator(chunkSource, rowSequence, chunkSize, rowSequence.firstRowKey(), rowSequence.size());
                break;
            }
            case Int: {
                result = new ChunkedIntegerColumnIterator(chunkSource, rowSequence, chunkSize, rowSequence.firstRowKey(), rowSequence.size());
                break;
            }
            case Long: {
                result = new ChunkedLongColumnIterator(chunkSource, rowSequence, chunkSize, rowSequence.firstRowKey(), rowSequence.size());
                break;
            }
            case Float: {
                result = new ChunkedFloatColumnIterator(chunkSource, rowSequence, chunkSize, rowSequence.firstRowKey(), rowSequence.size());
                break;
            }
            case Double: {
                result = new ChunkedDoubleColumnIterator(chunkSource, rowSequence, chunkSize, rowSequence.firstRowKey(), rowSequence.size());
                break;
            }
            case Object: {
                result = new ChunkedObjectColumnIterator(chunkSource, rowSequence, chunkSize, rowSequence.firstRowKey(), rowSequence.size());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unexpected chunk type: " + chunkSource.getChunkType());
            }
        }
        return result;
    }
}

