/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.iterators;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.iterators.ChunkedColumnIterator;
import io.deephaven.engine.table.iterators.DoubleColumnIterator;
import java.util.function.DoubleConsumer;
import org.jetbrains.annotations.NotNull;

public final class ChunkedDoubleColumnIterator
extends ChunkedColumnIterator<Double, DoubleChunk<? extends Any>>
implements DoubleColumnIterator {
    public ChunkedDoubleColumnIterator(@NotNull ChunkSource<? extends Any> chunkSource, @NotNull RowSequence rowSequence, int chunkSize, long firstRowKey, long length) {
        super(ChunkedDoubleColumnIterator.validateChunkType(chunkSource, ChunkType.Double), rowSequence, chunkSize, firstRowKey, length);
    }

    public ChunkedDoubleColumnIterator(@NotNull ChunkSource<? extends Any> chunkSource, @NotNull RowSequence rowSequence) {
        this(chunkSource, rowSequence, 2048, rowSequence.firstRowKey(), rowSequence.size());
    }

    @Override
    DoubleChunk<? extends Any> castChunk(@NotNull Chunk<? extends Any> chunk) {
        return chunk.asDoubleChunk();
    }

    public double nextDouble() {
        this.maybeAdvance();
        return ((DoubleChunk)this.currentData).get(this.currentOffset++);
    }

    public void forEachRemaining(@NotNull DoubleConsumer action) {
        this.consumeRemainingByChunks(() -> {
            int currentSize = ((DoubleChunk)this.currentData).size();
            while (this.currentOffset < currentSize) {
                action.accept(((DoubleChunk)this.currentData).get(this.currentOffset++));
            }
        });
    }
}

