/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.iterators;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.FloatChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.engine.primitive.function.FloatConsumer;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.iterators.ChunkedColumnIterator;
import io.deephaven.engine.table.iterators.FloatColumnIterator;
import org.jetbrains.annotations.NotNull;

public final class ChunkedFloatColumnIterator
extends ChunkedColumnIterator<Float, FloatChunk<? extends Any>>
implements FloatColumnIterator {
    public ChunkedFloatColumnIterator(@NotNull ChunkSource<? extends Any> chunkSource, @NotNull RowSequence rowSequence, int chunkSize, long firstRowKey, long length) {
        super(ChunkedFloatColumnIterator.validateChunkType(chunkSource, ChunkType.Float), rowSequence, chunkSize, firstRowKey, length);
    }

    public ChunkedFloatColumnIterator(@NotNull ChunkSource<? extends Any> chunkSource, @NotNull RowSequence rowSequence) {
        this(chunkSource, rowSequence, 2048, rowSequence.firstRowKey(), rowSequence.size());
    }

    @Override
    FloatChunk<? extends Any> castChunk(@NotNull Chunk<? extends Any> chunk) {
        return chunk.asFloatChunk();
    }

    public float nextFloat() {
        this.maybeAdvance();
        return ((FloatChunk)this.currentData).get(this.currentOffset++);
    }

    public void forEachRemaining(@NotNull FloatConsumer action) {
        this.consumeRemainingByChunks(() -> {
            int currentSize = ((FloatChunk)this.currentData).size();
            while (this.currentOffset < currentSize) {
                action.accept(((FloatChunk)this.currentData).get(this.currentOffset++));
            }
        });
    }
}

