/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.iterators;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.iterators.ChunkedColumnIterator;
import io.deephaven.engine.table.iterators.IntegerColumnIterator;
import java.util.function.IntConsumer;
import org.jetbrains.annotations.NotNull;

public final class ChunkedIntegerColumnIterator
extends ChunkedColumnIterator<Integer, IntChunk<? extends Any>>
implements IntegerColumnIterator {
    public ChunkedIntegerColumnIterator(@NotNull ChunkSource<? extends Any> chunkSource, @NotNull RowSequence rowSequence, int chunkSize, long firstRowKey, long length) {
        super(ChunkedIntegerColumnIterator.validateChunkType(chunkSource, ChunkType.Int), rowSequence, chunkSize, firstRowKey, length);
    }

    public ChunkedIntegerColumnIterator(@NotNull ChunkSource<? extends Any> chunkSource, @NotNull RowSequence rowSequence) {
        this(chunkSource, rowSequence, 2048, rowSequence.firstRowKey(), rowSequence.size());
    }

    @Override
    IntChunk<? extends Any> castChunk(@NotNull Chunk<? extends Any> chunk) {
        return chunk.asIntChunk();
    }

    public int nextInt() {
        this.maybeAdvance();
        return ((IntChunk)this.currentData).get(this.currentOffset++);
    }

    public void forEachRemaining(@NotNull IntConsumer action) {
        this.consumeRemainingByChunks(() -> {
            int currentSize = ((IntChunk)this.currentData).size();
            while (this.currentOffset < currentSize) {
                action.accept(((IntChunk)this.currentData).get(this.currentOffset++));
            }
        });
    }
}

