/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.iterators;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.iterators.ChunkedColumnIterator;
import io.deephaven.engine.table.iterators.LongColumnIterator;
import java.util.function.LongConsumer;
import org.jetbrains.annotations.NotNull;

public final class ChunkedLongColumnIterator
extends ChunkedColumnIterator<Long, LongChunk<? extends Any>>
implements LongColumnIterator {
    public ChunkedLongColumnIterator(@NotNull ChunkSource<? extends Any> chunkSource, @NotNull RowSequence rowSequence, int chunkSize, long firstRowKey, long length) {
        super(ChunkedLongColumnIterator.validateChunkType(chunkSource, ChunkType.Long), rowSequence, chunkSize, firstRowKey, length);
    }

    public ChunkedLongColumnIterator(@NotNull ChunkSource<? extends Any> chunkSource, @NotNull RowSequence rowSequence) {
        this(chunkSource, rowSequence, 2048, rowSequence.firstRowKey(), rowSequence.size());
    }

    @Override
    LongChunk<? extends Any> castChunk(@NotNull Chunk<? extends Any> chunk) {
        return chunk.asLongChunk();
    }

    public long nextLong() {
        this.maybeAdvance();
        return ((LongChunk)this.currentData).get(this.currentOffset++);
    }

    public void forEachRemaining(@NotNull LongConsumer action) {
        this.consumeRemainingByChunks(() -> {
            int currentSize = ((LongChunk)this.currentData).size();
            while (this.currentOffset < currentSize) {
                action.accept(((LongChunk)this.currentData).get(this.currentOffset++));
            }
        });
    }
}

