/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.iterators;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.iterators.ChunkedColumnIterator;
import io.deephaven.engine.table.iterators.ObjectColumnIterator;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public final class ChunkedObjectColumnIterator<DATA_TYPE>
extends ChunkedColumnIterator<DATA_TYPE, ObjectChunk<DATA_TYPE, ? extends Any>>
implements ObjectColumnIterator<DATA_TYPE> {
    public ChunkedObjectColumnIterator(@NotNull ChunkSource<? extends Any> chunkSource, @NotNull RowSequence rowSequence, int chunkSize, long firstRowKey, long length) {
        super(ChunkedObjectColumnIterator.validateChunkType(chunkSource, ChunkType.Object), rowSequence, chunkSize, firstRowKey, length);
    }

    public ChunkedObjectColumnIterator(@NotNull ChunkSource<? extends Any> chunkSource, @NotNull RowSequence rowSequence) {
        this(ChunkedObjectColumnIterator.validateChunkType(chunkSource, ChunkType.Object), rowSequence, 2048, rowSequence.firstRowKey(), rowSequence.size());
    }

    @Override
    ObjectChunk<DATA_TYPE, ? extends Any> castChunk(@NotNull Chunk<? extends Any> chunk) {
        return chunk.asObjectChunk().asTypedObjectChunk();
    }

    public DATA_TYPE next() {
        this.maybeAdvance();
        return (DATA_TYPE)((ObjectChunk)this.currentData).get(this.currentOffset++);
    }

    public void forEachRemaining(@NotNull Consumer<? super DATA_TYPE> action) {
        this.consumeRemainingByChunks(() -> {
            int currentSize = ((ObjectChunk)this.currentData).size();
            while (this.currentOffset < currentSize) {
                action.accept((DATA_TYPE)((ObjectChunk)this.currentData).get(this.currentOffset++));
            }
        });
    }
}

