/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.iterators;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.engine.primitive.function.ShortConsumer;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.iterators.ChunkedColumnIterator;
import io.deephaven.engine.table.iterators.ShortColumnIterator;
import org.jetbrains.annotations.NotNull;

public final class ChunkedShortColumnIterator
extends ChunkedColumnIterator<Short, ShortChunk<? extends Any>>
implements ShortColumnIterator {
    public ChunkedShortColumnIterator(@NotNull ChunkSource<? extends Any> chunkSource, @NotNull RowSequence rowSequence, int chunkSize, long firstRowKey, long length) {
        super(ChunkedShortColumnIterator.validateChunkType(chunkSource, ChunkType.Short), rowSequence, chunkSize, firstRowKey, length);
    }

    public ChunkedShortColumnIterator(@NotNull ChunkSource<? extends Any> chunkSource, @NotNull RowSequence rowSequence) {
        this(chunkSource, rowSequence, 2048, rowSequence.firstRowKey(), rowSequence.size());
    }

    @Override
    ShortChunk<? extends Any> castChunk(@NotNull Chunk<? extends Any> chunk) {
        return chunk.asShortChunk();
    }

    public short nextShort() {
        this.maybeAdvance();
        return ((ShortChunk)this.currentData).get(this.currentOffset++);
    }

    public void forEachRemaining(@NotNull ShortConsumer action) {
        this.consumeRemainingByChunks(() -> {
            int currentSize = ((ShortChunk)this.currentData).size();
            while (this.currentOffset < currentSize) {
                action.accept(((ShortChunk)this.currentData).get(this.currentOffset++));
            }
        });
    }
}

