/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.iterators;

import io.deephaven.engine.primitive.function.FloatToDoubleFunction;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfDouble;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfFloat;
import io.deephaven.engine.table.iterators.ColumnIterator;
import io.deephaven.util.annotations.FinalDefault;
import io.deephaven.util.type.TypeUtils;
import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;

public interface FloatColumnIterator
extends ColumnIterator<Float>,
CloseablePrimitiveIteratorOfFloat {
    @FinalDefault
    default public Float next() {
        return TypeUtils.box((float)this.nextFloat());
    }

    @FinalDefault
    default public void forEachRemaining(@NotNull Consumer<? super Float> action) {
        this.forEachRemaining(element -> action.accept(TypeUtils.box((float)element)));
    }

    @FinalDefault
    default public DoubleStream streamAsDouble(@NotNull FloatToDoubleFunction adapter) {
        CloseablePrimitiveIteratorOfDouble adapted = this.adaptToOfDouble(adapter);
        return (DoubleStream)StreamSupport.doubleStream(Spliterators.spliterator((PrimitiveIterator.OfDouble)adapted, this.remaining(), 1040), false).onClose(() -> ((FloatColumnIterator)this).close());
    }

    @FinalDefault
    default public DoubleStream streamAsDouble() {
        return this.streamAsDouble(value -> value == -3.4028235E38f ? -1.7976931348623157E308 : (double)value);
    }

    @FinalDefault
    default public Stream<Float> stream() {
        return (Stream)StreamSupport.stream(Spliterators.spliterator(this, this.remaining(), 1040), false).onClose(() -> ((FloatColumnIterator)this).close());
    }
}

