/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.iterators;

import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.iterators.ColumnIterator;
import io.deephaven.engine.table.iterators.SerialByteColumnIterator;
import io.deephaven.engine.table.iterators.SerialCharacterColumnIterator;
import io.deephaven.engine.table.iterators.SerialDoubleColumnIterator;
import io.deephaven.engine.table.iterators.SerialFloatColumnIterator;
import io.deephaven.engine.table.iterators.SerialIntegerColumnIterator;
import io.deephaven.engine.table.iterators.SerialLongColumnIterator;
import io.deephaven.engine.table.iterators.SerialObjectColumnIterator;
import io.deephaven.engine.table.iterators.SerialShortColumnIterator;
import io.deephaven.util.SimpleTypeMap;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;

public abstract class SerialColumnIterator<DATA_TYPE>
implements ColumnIterator<DATA_TYPE> {
    final ColumnSource<DATA_TYPE> columnSource;
    private final RowSet rowSet;
    private final long lastRowPositionExclusive;
    private long nextRowPosition;
    private static final SimpleTypeMap<BiFunction<ColumnSource<?>, RowSet, SerialColumnIterator<?>>> TYPE_TO_CONSTRUCTOR = SimpleTypeMap.create((columnSource, rowSet) -> {
        throw new UnsupportedOperationException("Primitive boolean ColumnSources are unsupported");
    }, (columnSource, rowSet) -> new SerialCharacterColumnIterator((ColumnSource<Character>)columnSource, (RowSet)rowSet), (columnSource, rowSet) -> new SerialByteColumnIterator((ColumnSource<Byte>)columnSource, (RowSet)rowSet), (columnSource, rowSet) -> new SerialShortColumnIterator((ColumnSource<Short>)columnSource, (RowSet)rowSet), (columnSource, rowSet) -> new SerialIntegerColumnIterator((ColumnSource<Integer>)columnSource, (RowSet)rowSet), (columnSource, rowSet) -> new SerialLongColumnIterator((ColumnSource<Long>)columnSource, (RowSet)rowSet), (columnSource, rowSet) -> new SerialFloatColumnIterator((ColumnSource<Float>)columnSource, (RowSet)rowSet), (columnSource, rowSet) -> new SerialDoubleColumnIterator((ColumnSource<Double>)columnSource, (RowSet)rowSet), (columnSource, rowSet) -> new SerialObjectColumnIterator(columnSource, (RowSet)rowSet));

    SerialColumnIterator(@NotNull ColumnSource<DATA_TYPE> columnSource, @NotNull RowSet rowSet, long firstRowKey, long length) {
        this.columnSource = columnSource;
        this.rowSet = rowSet;
        if (firstRowKey == rowSet.firstRowKey()) {
            this.nextRowPosition = 0L;
        } else {
            this.nextRowPosition = rowSet.find(firstRowKey);
            if (this.nextRowPosition < 0L) {
                throw new IllegalArgumentException(String.format("Invalid first row key %d, not present in iteration row set", firstRowKey));
            }
        }
        if (rowSet.size() - this.nextRowPosition < length) {
            throw new IllegalArgumentException(String.format("Invalid length %d, iteration row set only contains %d rows (%d already consumed)", length, rowSet.size(), this.nextRowPosition));
        }
        this.lastRowPositionExclusive = this.nextRowPosition + length;
    }

    @Override
    public final long remaining() {
        return this.lastRowPositionExclusive - this.nextRowPosition;
    }

    public final boolean hasNext() {
        return this.nextRowPosition != this.lastRowPositionExclusive;
    }

    final long advanceAndGetNextRowKey() {
        if (this.nextRowPosition == this.lastRowPositionExclusive) {
            throw new NoSuchElementException();
        }
        return this.rowSet.get(this.nextRowPosition++);
    }

    public static <DATA_TYPE> ColumnIterator<DATA_TYPE> make(@NotNull ColumnSource<DATA_TYPE> columnSource, @NotNull RowSet rowSet) {
        return (ColumnIterator)((BiFunction)TYPE_TO_CONSTRUCTOR.get(columnSource.getType())).apply(columnSource, rowSet);
    }
}

