/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.iterators;

import io.deephaven.engine.primitive.function.ShortToIntFunction;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfInt;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfShort;
import io.deephaven.engine.table.iterators.ColumnIterator;
import io.deephaven.util.annotations.FinalDefault;
import io.deephaven.util.type.TypeUtils;
import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;

public interface ShortColumnIterator
extends ColumnIterator<Short>,
CloseablePrimitiveIteratorOfShort {
    @FinalDefault
    default public Short next() {
        return TypeUtils.box((short)this.nextShort());
    }

    @FinalDefault
    default public void forEachRemaining(@NotNull Consumer<? super Short> action) {
        this.forEachRemaining(element -> action.accept(TypeUtils.box((short)element)));
    }

    @FinalDefault
    default public IntStream streamAsInt(@NotNull ShortToIntFunction adapter) {
        CloseablePrimitiveIteratorOfInt adapted = this.adaptToOfInt(adapter);
        return (IntStream)StreamSupport.intStream(Spliterators.spliterator((PrimitiveIterator.OfInt)adapted, this.remaining(), 1040), false).onClose(() -> ((ShortColumnIterator)this).close());
    }

    @FinalDefault
    default public IntStream streamAsInt() {
        return this.streamAsInt(value -> value == Short.MIN_VALUE ? Integer.MIN_VALUE : (int)value);
    }

    @FinalDefault
    default public Stream<Short> stream() {
        return (Stream)StreamSupport.stream(Spliterators.spliterator(this, this.remaining(), 1040), false).onClose(() -> ((ShortColumnIterator)this).close());
    }
}

