/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSequenceFactory;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.Context;
import io.deephaven.engine.table.SharedContext;
import io.deephaven.engine.table.impl.DefaultGetContext;
import io.deephaven.util.annotations.FinalDefault;
import org.jetbrains.annotations.NotNull;

public interface DefaultChunkSource<ATTR extends Any>
extends ChunkSource<ATTR> {
    default public ChunkSource.GetContext makeGetContext(int chunkCapacity, SharedContext sharedContext) {
        return new DefaultGetContext(this, chunkCapacity, sharedContext);
    }

    default public ChunkSource.FillContext makeFillContext(int chunkCapacity, SharedContext sharedContext) {
        return DEFAULT_FILL_INSTANCE;
    }

    default public Chunk<? extends ATTR> getChunk(@NotNull ChunkSource.GetContext context, @NotNull RowSequence rowSequence) {
        return this.getChunkByFilling(context, rowSequence);
    }

    default public Chunk<? extends ATTR> getChunk(@NotNull ChunkSource.GetContext context, long firstKey, long lastKey) {
        try (RowSequence rowSequence = RowSequenceFactory.forRange((long)firstKey, (long)lastKey);){
            Chunk<ATTR> chunk = this.getChunk(context, rowSequence);
            return chunk;
        }
    }

    @FinalDefault
    default public Chunk<ATTR> getChunkByFilling(@NotNull ChunkSource.GetContext context, @NotNull RowSequence rowSequence) {
        Object chunk = DefaultGetContext.getWritableChunk((Context)context);
        this.fillChunk(DefaultGetContext.getFillContext(context), (WritableChunk)chunk, rowSequence);
        return chunk;
    }

    public static interface SupportsContiguousGet<ATTR extends Any>
    extends DefaultChunkSource<ATTR> {
        @Override
        default public Chunk<? extends ATTR> getChunk(@NotNull ChunkSource.GetContext context, @NotNull RowSequence rowSequence) {
            return rowSequence.isContiguous() ? this.getChunk(context, rowSequence.firstRowKey(), rowSequence.lastRowKey()) : this.getChunkByFilling(context, rowSequence);
        }

        @Override
        public Chunk<? extends ATTR> getChunk(@NotNull ChunkSource.GetContext var1, long var2, long var4);
    }

    public static interface WithPrev<ATTR extends Any>
    extends DefaultChunkSource<ATTR>,
    ChunkSource.WithPrev<ATTR> {
        default public Chunk<? extends ATTR> getPrevChunk(@NotNull ChunkSource.GetContext context, @NotNull RowSequence rowSequence) {
            return this.getPrevChunkByFilling(context, rowSequence);
        }

        default public Chunk<? extends ATTR> getPrevChunk(@NotNull ChunkSource.GetContext context, long firstKey, long lastKey) {
            try (RowSequence rowSequence = RowSequenceFactory.forRange((long)firstKey, (long)lastKey);){
                Chunk<ATTR> chunk = this.getPrevChunk(context, rowSequence);
                return chunk;
            }
        }

        @FinalDefault
        default public Chunk<ATTR> getPrevChunkByFilling(@NotNull ChunkSource.GetContext context, @NotNull RowSequence rowSequence) {
            Object chunk = DefaultGetContext.getWritableChunk((Context)context);
            this.fillPrevChunk(DefaultGetContext.getFillContext(context), (WritableChunk)chunk, rowSequence);
            return chunk;
        }

        default public ChunkSource<ATTR> getPrevSource() {
            final WithPrev chunkSource = this;
            return new ChunkSource<ATTR>(){

                public ChunkType getChunkType() {
                    return chunkSource.getChunkType();
                }

                public Chunk<? extends ATTR> getChunk(@NotNull ChunkSource.GetContext context, @NotNull RowSequence rowSequence) {
                    return chunkSource.getPrevChunk(context, rowSequence);
                }

                public Chunk<? extends ATTR> getChunk(@NotNull ChunkSource.GetContext context, long firstKey, long lastKey) {
                    return chunkSource.getPrevChunk(context, firstKey, lastKey);
                }

                public void fillChunk(@NotNull ChunkSource.FillContext context, @NotNull WritableChunk<? super ATTR> destination, @NotNull RowSequence rowSequence) {
                    chunkSource.fillPrevChunk(context, destination, rowSequence);
                }

                public ChunkSource.GetContext makeGetContext(int chunkCapacity, SharedContext sharedContext) {
                    return chunkSource.makeGetContext(chunkCapacity, sharedContext);
                }

                public ChunkSource.FillContext makeFillContext(int chunkCapacity, SharedContext sharedContext) {
                    return chunkSource.makeFillContext(chunkCapacity, sharedContext);
                }
            };
        }
    }
}

