/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.chunkboxer;

import io.deephaven.chunk.BooleanChunk;
import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.FloatChunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.Context;
import io.deephaven.util.type.TypeUtils;

public class ChunkBoxer {
    private static final ObjectBoxer OBJECT_BOXER = new ObjectBoxer();

    public static BoxerKernel getBoxer(ChunkType type, int capacity) {
        switch (type) {
            case Boolean: {
                return new BooleanBoxer(capacity);
            }
            case Char: {
                return new CharBoxer(capacity);
            }
            case Byte: {
                return new ByteBoxer(capacity);
            }
            case Short: {
                return new ShortBoxer(capacity);
            }
            case Int: {
                return new IntBoxer(capacity);
            }
            case Long: {
                return new LongBoxer(capacity);
            }
            case Float: {
                return new FloatBoxer(capacity);
            }
            case Double: {
                return new DoubleBoxer(capacity);
            }
            case Object: {
                return OBJECT_BOXER;
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    private static class DoubleBoxer
    extends BoxerCommon {
        DoubleBoxer(int capacity) {
            super(capacity);
        }

        @Override
        public ObjectChunk<?, ? extends Values> box(Chunk<? extends Values> primitives) {
            DoubleChunk doubleChunk = primitives.asDoubleChunk();
            for (int ii = 0; ii < primitives.size(); ++ii) {
                this.objectChunk.set(ii, (Object)TypeUtils.box((double)doubleChunk.get(ii)));
            }
            this.objectChunk.setSize(primitives.size());
            return this.objectChunk;
        }
    }

    private static class FloatBoxer
    extends BoxerCommon {
        FloatBoxer(int capacity) {
            super(capacity);
        }

        @Override
        public ObjectChunk<?, ? extends Values> box(Chunk<? extends Values> primitives) {
            FloatChunk floatChunk = primitives.asFloatChunk();
            for (int ii = 0; ii < primitives.size(); ++ii) {
                this.objectChunk.set(ii, (Object)TypeUtils.box((float)floatChunk.get(ii)));
            }
            this.objectChunk.setSize(primitives.size());
            return this.objectChunk;
        }
    }

    private static class LongBoxer
    extends BoxerCommon {
        LongBoxer(int capacity) {
            super(capacity);
        }

        @Override
        public ObjectChunk<?, ? extends Values> box(Chunk<? extends Values> primitives) {
            LongChunk longChunk = primitives.asLongChunk();
            for (int ii = 0; ii < primitives.size(); ++ii) {
                this.objectChunk.set(ii, (Object)TypeUtils.box((long)longChunk.get(ii)));
            }
            this.objectChunk.setSize(primitives.size());
            return this.objectChunk;
        }
    }

    private static class IntBoxer
    extends BoxerCommon {
        IntBoxer(int capacity) {
            super(capacity);
        }

        @Override
        public ObjectChunk<?, ? extends Values> box(Chunk<? extends Values> primitives) {
            IntChunk intChunk = primitives.asIntChunk();
            for (int ii = 0; ii < primitives.size(); ++ii) {
                this.objectChunk.set(ii, (Object)TypeUtils.box((int)intChunk.get(ii)));
            }
            this.objectChunk.setSize(primitives.size());
            return this.objectChunk;
        }
    }

    private static class ShortBoxer
    extends BoxerCommon {
        ShortBoxer(int capacity) {
            super(capacity);
        }

        @Override
        public ObjectChunk<?, ? extends Values> box(Chunk<? extends Values> primitives) {
            ShortChunk shortChunk = primitives.asShortChunk();
            for (int ii = 0; ii < primitives.size(); ++ii) {
                this.objectChunk.set(ii, (Object)TypeUtils.box((short)shortChunk.get(ii)));
            }
            this.objectChunk.setSize(primitives.size());
            return this.objectChunk;
        }
    }

    private static class ByteBoxer
    extends BoxerCommon {
        ByteBoxer(int capacity) {
            super(capacity);
        }

        @Override
        public ObjectChunk<?, ? extends Values> box(Chunk<? extends Values> primitives) {
            ByteChunk byteChunk = primitives.asByteChunk();
            for (int ii = 0; ii < primitives.size(); ++ii) {
                this.objectChunk.set(ii, (Object)TypeUtils.box((byte)byteChunk.get(ii)));
            }
            this.objectChunk.setSize(primitives.size());
            return this.objectChunk;
        }
    }

    private static class CharBoxer
    extends BoxerCommon {
        CharBoxer(int capacity) {
            super(capacity);
        }

        @Override
        public ObjectChunk<?, ? extends Values> box(Chunk<? extends Values> primitives) {
            CharChunk charChunk = primitives.asCharChunk();
            for (int ii = 0; ii < primitives.size(); ++ii) {
                this.objectChunk.set(ii, (Object)TypeUtils.box((char)charChunk.get(ii)));
            }
            this.objectChunk.setSize(primitives.size());
            return this.objectChunk;
        }
    }

    private static class BooleanBoxer
    extends BoxerCommon {
        BooleanBoxer(int capacity) {
            super(capacity);
        }

        @Override
        public ObjectChunk<?, ? extends Values> box(Chunk<? extends Values> primitives) {
            BooleanChunk booleanChunk = primitives.asBooleanChunk();
            for (int ii = 0; ii < primitives.size(); ++ii) {
                this.objectChunk.set(ii, (Object)booleanChunk.get(ii));
            }
            this.objectChunk.setSize(primitives.size());
            return this.objectChunk;
        }
    }

    private static abstract class BoxerCommon
    implements BoxerKernel {
        final WritableObjectChunk<Object, Values> objectChunk;

        private BoxerCommon(int capacity) {
            this.objectChunk = WritableObjectChunk.makeWritableChunk((int)capacity);
        }

        public void close() {
            this.objectChunk.close();
        }
    }

    private static class ObjectBoxer
    implements BoxerKernel {
        private ObjectBoxer() {
        }

        @Override
        public ObjectChunk<?, ? extends Values> box(Chunk<? extends Values> primitives) {
            return primitives.asObjectChunk();
        }
    }

    public static interface BoxerKernel
    extends Context {
        public ObjectChunk<?, ? extends Values> box(Chunk<? extends Values> var1);
    }
}

