/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkBase;
import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.WritableBooleanChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.util.type.ArrayTypeUtils;

public class BooleanChunk<ATTR extends Any>
extends ChunkBase<ATTR> {
    private static final BooleanChunk EMPTY = new BooleanChunk(ArrayTypeUtils.EMPTY_BOOLEAN_ARRAY, 0, 0);
    private static final BooleanChunk[] EMPTY_BOOLEAN_CHUNK_ARRAY = new BooleanChunk[0];
    boolean[] data;

    public static <ATTR extends Any> BooleanChunk<ATTR> getEmptyChunk() {
        return EMPTY;
    }

    static <ATTR extends Any> BooleanChunk<ATTR>[] getEmptyChunkArray() {
        return EMPTY_BOOLEAN_CHUNK_ARRAY;
    }

    public static boolean[] makeArray(int capacity) {
        if (capacity == 0) {
            return ArrayTypeUtils.EMPTY_BOOLEAN_ARRAY;
        }
        return new boolean[capacity];
    }

    public static <ATTR extends Any> BooleanChunk<ATTR> chunkWrap(boolean[] data) {
        return BooleanChunk.chunkWrap(data, 0, data.length);
    }

    public static <ATTR extends Any> BooleanChunk<ATTR> chunkWrap(boolean[] data, int offset, int capacity) {
        return new BooleanChunk<ATTR>(data, offset, capacity);
    }

    protected BooleanChunk(boolean[] data, int offset, int capacity) {
        super(data.length, offset, capacity);
        this.data = data;
    }

    @Override
    public final ChunkType getChunkType() {
        return ChunkType.Boolean;
    }

    public final boolean get(int index) {
        return this.data[this.offset + index];
    }

    @Override
    public BooleanChunk<ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new BooleanChunk<ATTR>(this.data, this.offset + offset, capacity);
    }

    @Override
    public final void copyToChunk(int srcOffset, WritableChunk<? super ATTR> dest, int destOffset, int length) {
        WritableBooleanChunk<? super ATTR> wDest = dest.asWritableBooleanChunk();
        this.copyToTypedArray(srcOffset, wDest.data, wDest.offset + destOffset, length);
    }

    @Override
    public final void copyToArray(int srcOffset, Object dest, int destOffset, int length) {
        boolean[] realType = (boolean[])dest;
        this.copyToTypedArray(srcOffset, realType, destOffset, length);
    }

    public final void copyToTypedArray(int srcOffset, boolean[] destData, int destOffset, int length) {
        int sStart = this.offset + srcOffset;
        if (length >= 16) {
            System.arraycopy(this.data, sStart, destData, destOffset, length);
            return;
        }
        if (ChunkHelpers.canCopyForward(this.data, sStart, destData, destOffset, length)) {
            for (int ii = 0; ii < length; ++ii) {
                destData[destOffset + ii] = this.data[sStart + ii];
            }
            return;
        }
        for (int ii = length - 1; ii >= 0; --ii) {
            destData[destOffset + ii] = this.data[sStart + ii];
        }
    }

    @Override
    public final boolean isAlias(Object array) {
        return this.data == array;
    }

    @Override
    public final boolean isAlias(Chunk<?> chunk) {
        return chunk.isAlias(this.data);
    }

    @Override
    public final <V extends Chunk.Visitor<ATTR>> V walk(V visitor) {
        visitor.visit(this);
        return visitor;
    }

    public static <ATTR extends Any, ATTR_DERIV extends ATTR> BooleanChunk<ATTR_DERIV> downcast(BooleanChunk<ATTR> self) {
        return self;
    }
}

