/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.BooleanChunk;
import io.deephaven.chunk.ChunkChunk;
import io.deephaven.chunk.ChunkChunkBase;
import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.attributes.Any;

public class BooleanChunkChunk<ATTR extends Any>
extends ChunkChunkBase<ATTR>
implements ChunkChunk<ATTR> {
    private static final BooleanChunkChunk EMPTY = new BooleanChunkChunk(new BooleanChunk[0], 0, 0);
    BooleanChunk<ATTR>[] data;
    boolean[][] innerData;
    int[] innerOffsets;

    public static <ATTR extends Any> BooleanChunkChunk<ATTR> getEmptyChunk() {
        return EMPTY;
    }

    public static <ATTR extends Any> BooleanChunk<ATTR>[] makeArray(int capacity) {
        return new BooleanChunk[capacity];
    }

    public static <ATTR extends Any> BooleanChunkChunk<ATTR> chunkWrap(BooleanChunk<ATTR>[] data) {
        return new BooleanChunkChunk<ATTR>(data, 0, data.length);
    }

    public static <ATTR extends Any> BooleanChunkChunk<ATTR> chunkWrap(BooleanChunk<ATTR>[] data, int offset, int capacity) {
        return new BooleanChunkChunk<ATTR>(data, offset, capacity);
    }

    BooleanChunkChunk(BooleanChunk<ATTR>[] data, int offset, int capacity) {
        super(data.length, offset, capacity);
        this.data = data;
        this.resetInnerCache(data, offset, 0, capacity);
    }

    final void resetInnerCache(BooleanChunk<ATTR>[] data, int offset, int oldCapacity, int newCapacity) {
        int ii;
        if (this.innerData == null || this.innerData.length < newCapacity) {
            this.innerData = new boolean[newCapacity][];
            this.innerOffsets = new int[newCapacity];
        }
        for (ii = 0; ii < newCapacity; ++ii) {
            this.resetInnerCacheItem(ii, data[ii + offset]);
        }
        for (ii = newCapacity; ii < oldCapacity; ++ii) {
            this.innerData[ii] = null;
            this.innerOffsets[ii] = 0;
        }
    }

    final void resetInnerCacheItem(int index, BooleanChunk<ATTR> chunk) {
        if (chunk == null) {
            this.innerData[index] = null;
            this.innerOffsets[index] = 0;
        } else {
            this.innerData[index] = chunk.data;
            this.innerOffsets[index] = chunk.offset;
        }
    }

    public final BooleanChunk<ATTR> get(int index) {
        return this.data[this.offset + index];
    }

    @Override
    public final BooleanChunk<ATTR> getChunk(int index) {
        return this.get(index);
    }

    public final boolean get(int j, int i) {
        return this.innerData[j][this.innerOffsets[j] + i];
    }

    @Override
    public BooleanChunkChunk<ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new BooleanChunkChunk<ATTR>(this.data, this.offset + offset, capacity);
    }
}

