/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.ChunkChunk;
import io.deephaven.chunk.ChunkChunkBase;
import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.attributes.Any;

public class ByteChunkChunk<ATTR extends Any>
extends ChunkChunkBase<ATTR>
implements ChunkChunk<ATTR> {
    private static final ByteChunkChunk EMPTY = new ByteChunkChunk(new ByteChunk[0], 0, 0);
    ByteChunk<ATTR>[] data;
    byte[][] innerData;
    int[] innerOffsets;

    public static <ATTR extends Any> ByteChunkChunk<ATTR> getEmptyChunk() {
        return EMPTY;
    }

    public static <ATTR extends Any> ByteChunk<ATTR>[] makeArray(int capacity) {
        return new ByteChunk[capacity];
    }

    public static <ATTR extends Any> ByteChunkChunk<ATTR> chunkWrap(ByteChunk<ATTR>[] data) {
        return new ByteChunkChunk<ATTR>(data, 0, data.length);
    }

    public static <ATTR extends Any> ByteChunkChunk<ATTR> chunkWrap(ByteChunk<ATTR>[] data, int offset, int capacity) {
        return new ByteChunkChunk<ATTR>(data, offset, capacity);
    }

    ByteChunkChunk(ByteChunk<ATTR>[] data, int offset, int capacity) {
        super(data.length, offset, capacity);
        this.data = data;
        this.resetInnerCache(data, offset, 0, capacity);
    }

    final void resetInnerCache(ByteChunk<ATTR>[] data, int offset, int oldCapacity, int newCapacity) {
        int ii;
        if (this.innerData == null || this.innerData.length < newCapacity) {
            this.innerData = new byte[newCapacity][];
            this.innerOffsets = new int[newCapacity];
        }
        for (ii = 0; ii < newCapacity; ++ii) {
            this.resetInnerCacheItem(ii, data[ii + offset]);
        }
        for (ii = newCapacity; ii < oldCapacity; ++ii) {
            this.innerData[ii] = null;
            this.innerOffsets[ii] = 0;
        }
    }

    final void resetInnerCacheItem(int index, ByteChunk<ATTR> chunk) {
        if (chunk == null) {
            this.innerData[index] = null;
            this.innerOffsets[index] = 0;
        } else {
            this.innerData[index] = chunk.data;
            this.innerOffsets[index] = chunk.offset;
        }
    }

    public final ByteChunk<ATTR> get(int index) {
        return this.data[this.offset + index];
    }

    @Override
    public final ByteChunk<ATTR> getChunk(int index) {
        return this.get(index);
    }

    public final byte get(int j, int i) {
        return this.innerData[j][this.innerOffsets[j] + i];
    }

    @Override
    public ByteChunkChunk<ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new ByteChunkChunk<ATTR>(this.data, this.offset + offset, capacity);
    }
}

