/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.BooleanChunk;
import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.FloatChunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Any;
import java.nio.Buffer;
import org.jetbrains.annotations.NotNull;

public interface Chunk<ATTR extends Any> {
    public static final int SYSTEM_ARRAYCOPY_THRESHOLD = 16;
    public static final int SYSTEM_ARRAYFILL_THRESHOLD = 16;
    public static final int MAXIMUM_SIZE = Integer.MAX_VALUE;

    public Chunk<ATTR> slice(int var1, int var2);

    public void copyToChunk(int var1, WritableChunk<? super ATTR> var2, int var3, int var4);

    public void copyToArray(int var1, Object var2, int var3, int var4);

    default public void copyToBuffer(int srcOffset, @NotNull Buffer destBuffer, int destOffset, int length) {
        throw new UnsupportedOperationException();
    }

    public int size();

    public ChunkType getChunkType();

    default public void checkChunkType(ChunkType expected) {
        ChunkType actual = this.getChunkType();
        if (actual != expected) {
            throw new IllegalArgumentException(String.format("Expected chunk type '%s', but is '%s'.", expected, actual));
        }
    }

    public boolean isAlias(Object var1);

    public boolean isAlias(Chunk<?> var1);

    public <V extends Visitor<ATTR>> V walk(V var1);

    default public ByteChunk<ATTR> asByteChunk() {
        return (ByteChunk)this;
    }

    default public BooleanChunk<ATTR> asBooleanChunk() {
        return (BooleanChunk)this;
    }

    default public CharChunk<ATTR> asCharChunk() {
        return (CharChunk)this;
    }

    default public ShortChunk<ATTR> asShortChunk() {
        return (ShortChunk)this;
    }

    default public IntChunk<ATTR> asIntChunk() {
        return (IntChunk)this;
    }

    default public LongChunk<ATTR> asLongChunk() {
        return (LongChunk)this;
    }

    default public FloatChunk<ATTR> asFloatChunk() {
        return (FloatChunk)this;
    }

    default public DoubleChunk<ATTR> asDoubleChunk() {
        return (DoubleChunk)this;
    }

    default public <T> ObjectChunk<T, ATTR> asObjectChunk() {
        return (ObjectChunk)this;
    }

    public static <ATTR extends Any, ATTR_DERIV extends ATTR> Chunk<ATTR_DERIV> downcast(Chunk<? extends ATTR> self) {
        return self;
    }

    public static interface Visitor<ATTR extends Any> {
        public void visit(ByteChunk<ATTR> var1);

        public void visit(BooleanChunk<ATTR> var1);

        public void visit(CharChunk<ATTR> var1);

        public void visit(ShortChunk<ATTR> var1);

        public void visit(IntChunk<ATTR> var1);

        public void visit(LongChunk<ATTR> var1);

        public void visit(FloatChunk<ATTR> var1);

        public void visit(DoubleChunk<ATTR> var1);

        public <T> void visit(ObjectChunk<T, ATTR> var1);
    }
}

