/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.attributes.Any;

public abstract class ChunkBase<ATTR extends Any>
implements Chunk<ATTR> {
    int offset;
    int capacity;
    int size;

    ChunkBase(int arrayLength, int offset, int capacity) {
        ChunkHelpers.checkArrayArgs(arrayLength, offset, capacity);
        this.offset = offset;
        this.capacity = capacity;
        this.size = capacity;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void internalSetSize(int newSize, long password) {
        if (password != -7025656774858671822L) {
            throw new UnsupportedOperationException("DO NOT CALL THIS INTERNAL METHOD. Instead call WritableChunk.setSize()");
        }
        if (newSize < 0 || newSize > this.capacity) {
            throw new IllegalArgumentException(String.format("size %d is incompatible with capacity %d", newSize, this.capacity));
        }
        this.size = newSize;
    }

    public final int internalCapacity(long password) {
        if (password != 1837055652467547514L) {
            throw new UnsupportedOperationException("DO NOT CALL THIS INTERNAL METHOD. Instead call WritableChunk.capacity()");
        }
        return this.capacity;
    }
}

