/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

public class ChunkHelpers {
    static void checkSliceArgs(int size, int offset, int capacity) {
        if (offset < 0 || offset > size || capacity < 0 || capacity > size - offset) {
            throw new IllegalArgumentException(String.format("New slice offset %d, capacity %d is incompatible with size %d", offset, capacity, size));
        }
    }

    static void checkArrayArgs(int arrayLength, int offset, int capacity) {
        if (offset < 0 || capacity < 0 || capacity > arrayLength - offset) {
            throw new IllegalArgumentException(String.format("offset %d, capacity %d is incompatible with array of length %d", offset, capacity, arrayLength));
        }
    }

    static <TARRAY> boolean canCopyForward(TARRAY srcArray, int srcOffset, TARRAY destArray, int destOffset, int length) {
        return srcArray != destArray || srcOffset + length <= destOffset || srcOffset >= destOffset;
    }
}

