/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkChunk;
import io.deephaven.chunk.ResettableChunkChunk;
import io.deephaven.chunk.ResettableReadOnlyChunk;
import io.deephaven.chunk.ResettableWritableChunk;
import io.deephaven.chunk.ResettableWritableChunkChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableChunkChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.factories.BooleanChunkFactory;
import io.deephaven.chunk.util.factories.ByteChunkFactory;
import io.deephaven.chunk.util.factories.CharChunkFactory;
import io.deephaven.chunk.util.factories.ChunkFactory;
import io.deephaven.chunk.util.factories.DoubleChunkFactory;
import io.deephaven.chunk.util.factories.FloatChunkFactory;
import io.deephaven.chunk.util.factories.IntChunkFactory;
import io.deephaven.chunk.util.factories.LongChunkFactory;
import io.deephaven.chunk.util.factories.ObjectChunkFactory;
import io.deephaven.chunk.util.factories.ShortChunkFactory;
import io.deephaven.util.SimpleTypeMap;
import java.util.function.IntFunction;
import org.jetbrains.annotations.NotNull;

public enum ChunkType implements ChunkFactory
{
    Boolean(new BooleanChunkFactory()),
    Char(new CharChunkFactory()),
    Byte(new ByteChunkFactory()),
    Short(new ShortChunkFactory()),
    Int(new IntChunkFactory()),
    Long(new LongChunkFactory()),
    Float(new FloatChunkFactory()),
    Double(new DoubleChunkFactory()),
    Object(new ObjectChunkFactory<T>());

    private static final SimpleTypeMap<ChunkType> fromElementTypeMap;
    final ChunkFactory factory;

    public static ChunkType fromElementType(Class elementType) {
        return (ChunkType)fromElementTypeMap.get(elementType);
    }

    private ChunkType(ChunkFactory factory) {
        this.factory = factory;
    }

    @Override
    @NotNull
    public final Object makeArray(int capacity) {
        return this.factory.makeArray(capacity);
    }

    @Override
    @NotNull
    public <ATTR extends Any> Chunk<ATTR>[] makeChunkArray(int capacity) {
        return this.factory.makeChunkArray(capacity);
    }

    @Override
    @NotNull
    public <ATTR extends Any> Chunk<ATTR> getEmptyChunk() {
        return this.factory.getEmptyChunk();
    }

    @Override
    @NotNull
    public <ATTR extends Any> ChunkChunk<ATTR> getEmptyChunkChunk() {
        return this.factory.getEmptyChunkChunk();
    }

    @Override
    @NotNull
    public final <ATTR extends Any> Chunk<ATTR> chunkWrap(Object array) {
        return this.factory.chunkWrap(array);
    }

    @Override
    @NotNull
    public final <ATTR extends Any> Chunk<ATTR> chunkWrap(Object array, int offset, int capacity) {
        return this.factory.chunkWrap(array, offset, capacity);
    }

    @Override
    @NotNull
    public final <ATTR extends Any> ChunkChunk<ATTR> chunkChunkWrap(Chunk<ATTR>[] array) {
        return this.factory.chunkChunkWrap(array);
    }

    @Override
    @NotNull
    public final <ATTR extends Any> ChunkChunk<ATTR> chunkChunkWrap(Chunk<ATTR>[] array, int offset, int capacity) {
        return this.factory.chunkChunkWrap(array, offset, capacity);
    }

    @Override
    @NotNull
    public <ATTR extends Any> ResettableReadOnlyChunk<ATTR> makeResettableReadOnlyChunk() {
        return this.factory.makeResettableReadOnlyChunk();
    }

    @Override
    @NotNull
    public <ATTR extends Any> ResettableChunkChunk<ATTR> makeResettableChunkChunk() {
        return this.factory.makeResettableChunkChunk();
    }

    @Override
    @NotNull
    public final <ATTR extends Any> WritableChunk<ATTR> makeWritableChunk(int capacity) {
        return this.factory.makeWritableChunk(capacity);
    }

    @Override
    @NotNull
    public final <ATTR extends Any> WritableChunkChunk<ATTR> makeWritableChunkChunk(int capacity) {
        return this.factory.makeWritableChunkChunk(capacity);
    }

    @Override
    @NotNull
    public final <ATTR extends Any> WritableChunk<ATTR> writableChunkWrap(Object array, int offset, int capacity) {
        return this.factory.writableChunkWrap(array, offset, capacity);
    }

    @Override
    @NotNull
    public final <ATTR extends Any> WritableChunkChunk<ATTR> writableChunkChunkWrap(WritableChunk<ATTR>[] array, int offset, int capacity) {
        return this.factory.writableChunkChunkWrap(array, offset, capacity);
    }

    @Override
    @NotNull
    public <ATTR extends Any> ResettableWritableChunk<ATTR> makeResettableWritableChunk() {
        return this.factory.makeResettableWritableChunk();
    }

    @Override
    @NotNull
    public <ATTR extends Any> ResettableWritableChunkChunk<ATTR> makeResettableWritableChunkChunk() {
        return this.factory.makeResettableWritableChunkChunk();
    }

    @Override
    @NotNull
    public IntFunction<Chunk[]> chunkArrayBuilder() {
        return this.factory.chunkArrayBuilder();
    }

    @Override
    @NotNull
    public IntFunction<WritableChunk[]> writableChunkArrayBuilder() {
        return this.factory.writableChunkArrayBuilder();
    }

    static {
        fromElementTypeMap = SimpleTypeMap.create((Object)Boolean, (Object)Char, (Object)Byte, (Object)Short, (Object)Int, (Object)Long, (Object)Float, (Object)Double, (Object)Object);
    }
}

