/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.ChunkChunk;
import io.deephaven.chunk.ChunkChunkBase;
import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.attributes.Any;

public class DoubleChunkChunk<ATTR extends Any>
extends ChunkChunkBase<ATTR>
implements ChunkChunk<ATTR> {
    private static final DoubleChunkChunk EMPTY = new DoubleChunkChunk(new DoubleChunk[0], 0, 0);
    DoubleChunk<ATTR>[] data;
    double[][] innerData;
    int[] innerOffsets;

    public static <ATTR extends Any> DoubleChunkChunk<ATTR> getEmptyChunk() {
        return EMPTY;
    }

    public static <ATTR extends Any> DoubleChunk<ATTR>[] makeArray(int capacity) {
        return new DoubleChunk[capacity];
    }

    public static <ATTR extends Any> DoubleChunkChunk<ATTR> chunkWrap(DoubleChunk<ATTR>[] data) {
        return new DoubleChunkChunk<ATTR>(data, 0, data.length);
    }

    public static <ATTR extends Any> DoubleChunkChunk<ATTR> chunkWrap(DoubleChunk<ATTR>[] data, int offset, int capacity) {
        return new DoubleChunkChunk<ATTR>(data, offset, capacity);
    }

    DoubleChunkChunk(DoubleChunk<ATTR>[] data, int offset, int capacity) {
        super(data.length, offset, capacity);
        this.data = data;
        this.resetInnerCache(data, offset, 0, capacity);
    }

    final void resetInnerCache(DoubleChunk<ATTR>[] data, int offset, int oldCapacity, int newCapacity) {
        int ii;
        if (this.innerData == null || this.innerData.length < newCapacity) {
            this.innerData = new double[newCapacity][];
            this.innerOffsets = new int[newCapacity];
        }
        for (ii = 0; ii < newCapacity; ++ii) {
            this.resetInnerCacheItem(ii, data[ii + offset]);
        }
        for (ii = newCapacity; ii < oldCapacity; ++ii) {
            this.innerData[ii] = null;
            this.innerOffsets[ii] = 0;
        }
    }

    final void resetInnerCacheItem(int index, DoubleChunk<ATTR> chunk) {
        if (chunk == null) {
            this.innerData[index] = null;
            this.innerOffsets[index] = 0;
        } else {
            this.innerData[index] = chunk.data;
            this.innerOffsets[index] = chunk.offset;
        }
    }

    public final DoubleChunk<ATTR> get(int index) {
        return this.data[this.offset + index];
    }

    @Override
    public final DoubleChunk<ATTR> getChunk(int index) {
        return this.get(index);
    }

    public final double get(int j, int i) {
        return this.innerData[j][this.innerOffsets[j] + i];
    }

    @Override
    public DoubleChunkChunk<ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new DoubleChunkChunk<ATTR>(this.data, this.offset + offset, capacity);
    }
}

