/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkBase;
import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableFloatChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.util.type.ArrayTypeUtils;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class FloatChunk<ATTR extends Any>
extends ChunkBase<ATTR> {
    private static final FloatChunk EMPTY = new FloatChunk(ArrayTypeUtils.EMPTY_FLOAT_ARRAY, 0, 0);
    private static final FloatChunk[] EMPTY_FLOAT_CHUNK_ARRAY = new FloatChunk[0];
    float[] data;

    public static <ATTR extends Any> FloatChunk<ATTR> getEmptyChunk() {
        return EMPTY;
    }

    static <ATTR extends Any> FloatChunk<ATTR>[] getEmptyChunkArray() {
        return EMPTY_FLOAT_CHUNK_ARRAY;
    }

    public static float[] makeArray(int capacity) {
        if (capacity == 0) {
            return ArrayTypeUtils.EMPTY_FLOAT_ARRAY;
        }
        return new float[capacity];
    }

    public static <ATTR extends Any> FloatChunk<ATTR> chunkWrap(float[] data) {
        return FloatChunk.chunkWrap(data, 0, data.length);
    }

    public static <ATTR extends Any> FloatChunk<ATTR> chunkWrap(float[] data, int offset, int capacity) {
        return new FloatChunk<ATTR>(data, offset, capacity);
    }

    protected FloatChunk(float[] data, int offset, int capacity) {
        super(data.length, offset, capacity);
        this.data = data;
    }

    @Override
    public final ChunkType getChunkType() {
        return ChunkType.Float;
    }

    public final float get(int index) {
        return this.data[this.offset + index];
    }

    @Override
    public FloatChunk<ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new FloatChunk<ATTR>(this.data, this.offset + offset, capacity);
    }

    @Override
    public final void copyToChunk(int srcOffset, WritableChunk<? super ATTR> dest, int destOffset, int length) {
        WritableFloatChunk<? super ATTR> wDest = dest.asWritableFloatChunk();
        this.copyToTypedArray(srcOffset, wDest.data, wDest.offset + destOffset, length);
    }

    @Override
    public final void copyToArray(int srcOffset, Object dest, int destOffset, int length) {
        float[] realType = (float[])dest;
        this.copyToTypedArray(srcOffset, realType, destOffset, length);
    }

    public final void copyToTypedArray(int srcOffset, float[] destData, int destOffset, int length) {
        int sStart = this.offset + srcOffset;
        if (length >= 16) {
            System.arraycopy(this.data, sStart, destData, destOffset, length);
            return;
        }
        if (ChunkHelpers.canCopyForward(this.data, sStart, destData, destOffset, length)) {
            for (int ii = 0; ii < length; ++ii) {
                destData[destOffset + ii] = this.data[sStart + ii];
            }
            return;
        }
        for (int ii = length - 1; ii >= 0; --ii) {
            destData[destOffset + ii] = this.data[sStart + ii];
        }
    }

    @Override
    public final boolean isAlias(Object array) {
        return this.data == array;
    }

    @Override
    public final boolean isAlias(Chunk<?> chunk) {
        return chunk.isAlias(this.data);
    }

    @Override
    public final <V extends Chunk.Visitor<ATTR>> V walk(V visitor) {
        visitor.visit(this);
        return visitor;
    }

    @Override
    public final void copyToBuffer(int srcOffset, @NotNull Buffer destBuffer, int destOffset, int length) {
        FloatBuffer floatDestBuffer = (FloatBuffer)destBuffer;
        this.copyToTypedBuffer(srcOffset, floatDestBuffer, destOffset, length);
    }

    public final void copyToTypedBuffer(int srcOffset, @NotNull FloatBuffer destBuffer, int destOffset, int length) {
        if (destBuffer.hasArray()) {
            this.copyToTypedArray(srcOffset, destBuffer.array(), destBuffer.arrayOffset() + destOffset, length);
            return;
        }
        int initialPosition = destBuffer.position();
        destBuffer.position(destOffset);
        destBuffer.put(this.data, this.offset + srcOffset, length);
        destBuffer.position(initialPosition);
    }

    public static <ATTR extends Any, ATTR_DERIV extends ATTR> FloatChunk<ATTR_DERIV> downcast(FloatChunk<ATTR> self) {
        return self;
    }

    public final int binarySearch(float key) {
        return Arrays.binarySearch(this.data, this.offset, this.offset + this.size, key);
    }

    public final int binarySearch(int fromIndexInclusive, int toIndexExclusive, float key) {
        return Arrays.binarySearch(this.data, this.offset + fromIndexInclusive, this.offset + toIndexExclusive, key);
    }
}

