/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.ChunkChunk;
import io.deephaven.chunk.ChunkChunkBase;
import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.FloatChunk;
import io.deephaven.chunk.attributes.Any;

public class FloatChunkChunk<ATTR extends Any>
extends ChunkChunkBase<ATTR>
implements ChunkChunk<ATTR> {
    private static final FloatChunkChunk EMPTY = new FloatChunkChunk(new FloatChunk[0], 0, 0);
    FloatChunk<ATTR>[] data;
    float[][] innerData;
    int[] innerOffsets;

    public static <ATTR extends Any> FloatChunkChunk<ATTR> getEmptyChunk() {
        return EMPTY;
    }

    public static <ATTR extends Any> FloatChunk<ATTR>[] makeArray(int capacity) {
        return new FloatChunk[capacity];
    }

    public static <ATTR extends Any> FloatChunkChunk<ATTR> chunkWrap(FloatChunk<ATTR>[] data) {
        return new FloatChunkChunk<ATTR>(data, 0, data.length);
    }

    public static <ATTR extends Any> FloatChunkChunk<ATTR> chunkWrap(FloatChunk<ATTR>[] data, int offset, int capacity) {
        return new FloatChunkChunk<ATTR>(data, offset, capacity);
    }

    FloatChunkChunk(FloatChunk<ATTR>[] data, int offset, int capacity) {
        super(data.length, offset, capacity);
        this.data = data;
        this.resetInnerCache(data, offset, 0, capacity);
    }

    final void resetInnerCache(FloatChunk<ATTR>[] data, int offset, int oldCapacity, int newCapacity) {
        int ii;
        if (this.innerData == null || this.innerData.length < newCapacity) {
            this.innerData = new float[newCapacity][];
            this.innerOffsets = new int[newCapacity];
        }
        for (ii = 0; ii < newCapacity; ++ii) {
            this.resetInnerCacheItem(ii, data[ii + offset]);
        }
        for (ii = newCapacity; ii < oldCapacity; ++ii) {
            this.innerData[ii] = null;
            this.innerOffsets[ii] = 0;
        }
    }

    final void resetInnerCacheItem(int index, FloatChunk<ATTR> chunk) {
        if (chunk == null) {
            this.innerData[index] = null;
            this.innerOffsets[index] = 0;
        } else {
            this.innerData[index] = chunk.data;
            this.innerOffsets[index] = chunk.offset;
        }
    }

    public final FloatChunk<ATTR> get(int index) {
        return this.data[this.offset + index];
    }

    @Override
    public final FloatChunk<ATTR> getChunk(int index) {
        return this.get(index);
    }

    public final float get(int j, int i) {
        return this.innerData[j][this.innerOffsets[j] + i];
    }

    @Override
    public FloatChunkChunk<ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new FloatChunkChunk<ATTR>(this.data, this.offset + offset, capacity);
    }
}

