/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.ChunkChunk;
import io.deephaven.chunk.ChunkChunkBase;
import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.attributes.Any;

public class IntChunkChunk<ATTR extends Any>
extends ChunkChunkBase<ATTR>
implements ChunkChunk<ATTR> {
    private static final IntChunkChunk EMPTY = new IntChunkChunk(new IntChunk[0], 0, 0);
    IntChunk<ATTR>[] data;
    int[][] innerData;
    int[] innerOffsets;

    public static <ATTR extends Any> IntChunkChunk<ATTR> getEmptyChunk() {
        return EMPTY;
    }

    public static <ATTR extends Any> IntChunk<ATTR>[] makeArray(int capacity) {
        return new IntChunk[capacity];
    }

    public static <ATTR extends Any> IntChunkChunk<ATTR> chunkWrap(IntChunk<ATTR>[] data) {
        return new IntChunkChunk<ATTR>(data, 0, data.length);
    }

    public static <ATTR extends Any> IntChunkChunk<ATTR> chunkWrap(IntChunk<ATTR>[] data, int offset, int capacity) {
        return new IntChunkChunk<ATTR>(data, offset, capacity);
    }

    IntChunkChunk(IntChunk<ATTR>[] data, int offset, int capacity) {
        super(data.length, offset, capacity);
        this.data = data;
        this.resetInnerCache(data, offset, 0, capacity);
    }

    final void resetInnerCache(IntChunk<ATTR>[] data, int offset, int oldCapacity, int newCapacity) {
        int ii;
        if (this.innerData == null || this.innerData.length < newCapacity) {
            this.innerData = new int[newCapacity][];
            this.innerOffsets = new int[newCapacity];
        }
        for (ii = 0; ii < newCapacity; ++ii) {
            this.resetInnerCacheItem(ii, data[ii + offset]);
        }
        for (ii = newCapacity; ii < oldCapacity; ++ii) {
            this.innerData[ii] = null;
            this.innerOffsets[ii] = 0;
        }
    }

    final void resetInnerCacheItem(int index, IntChunk<ATTR> chunk) {
        if (chunk == null) {
            this.innerData[index] = null;
            this.innerOffsets[index] = 0;
        } else {
            this.innerData[index] = chunk.data;
            this.innerOffsets[index] = chunk.offset;
        }
    }

    public final IntChunk<ATTR> get(int index) {
        return this.data[this.offset + index];
    }

    @Override
    public final IntChunk<ATTR> getChunk(int index) {
        return this.get(index);
    }

    public final int get(int j, int i) {
        return this.innerData[j][this.innerOffsets[j] + i];
    }

    @Override
    public IntChunkChunk<ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new IntChunkChunk<ATTR>(this.data, this.offset + offset, capacity);
    }
}

