/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.ChunkChunk;
import io.deephaven.chunk.ChunkChunkBase;
import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.attributes.Any;

public class LongChunkChunk<ATTR extends Any>
extends ChunkChunkBase<ATTR>
implements ChunkChunk<ATTR> {
    private static final LongChunkChunk EMPTY = new LongChunkChunk(new LongChunk[0], 0, 0);
    LongChunk<ATTR>[] data;
    long[][] innerData;
    int[] innerOffsets;

    public static <ATTR extends Any> LongChunkChunk<ATTR> getEmptyChunk() {
        return EMPTY;
    }

    public static <ATTR extends Any> LongChunk<ATTR>[] makeArray(int capacity) {
        return new LongChunk[capacity];
    }

    public static <ATTR extends Any> LongChunkChunk<ATTR> chunkWrap(LongChunk<ATTR>[] data) {
        return new LongChunkChunk<ATTR>(data, 0, data.length);
    }

    public static <ATTR extends Any> LongChunkChunk<ATTR> chunkWrap(LongChunk<ATTR>[] data, int offset, int capacity) {
        return new LongChunkChunk<ATTR>(data, offset, capacity);
    }

    LongChunkChunk(LongChunk<ATTR>[] data, int offset, int capacity) {
        super(data.length, offset, capacity);
        this.data = data;
        this.resetInnerCache(data, offset, 0, capacity);
    }

    final void resetInnerCache(LongChunk<ATTR>[] data, int offset, int oldCapacity, int newCapacity) {
        int ii;
        if (this.innerData == null || this.innerData.length < newCapacity) {
            this.innerData = new long[newCapacity][];
            this.innerOffsets = new int[newCapacity];
        }
        for (ii = 0; ii < newCapacity; ++ii) {
            this.resetInnerCacheItem(ii, data[ii + offset]);
        }
        for (ii = newCapacity; ii < oldCapacity; ++ii) {
            this.innerData[ii] = null;
            this.innerOffsets[ii] = 0;
        }
    }

    final void resetInnerCacheItem(int index, LongChunk<ATTR> chunk) {
        if (chunk == null) {
            this.innerData[index] = null;
            this.innerOffsets[index] = 0;
        } else {
            this.innerData[index] = chunk.data;
            this.innerOffsets[index] = chunk.offset;
        }
    }

    public final LongChunk<ATTR> get(int index) {
        return this.data[this.offset + index];
    }

    @Override
    public final LongChunk<ATTR> getChunk(int index) {
        return this.get(index);
    }

    public final long get(int j, int i) {
        return this.innerData[j][this.innerOffsets[j] + i];
    }

    @Override
    public LongChunkChunk<ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new LongChunkChunk<ATTR>(this.data, this.offset + offset, capacity);
    }
}

