/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkBase;
import io.deephaven.chunk.ChunkHelpers;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.util.type.ArrayTypeUtils;
import java.util.Arrays;

public class ObjectChunk<T, ATTR extends Any>
extends ChunkBase<ATTR> {
    private static final ObjectChunk EMPTY = new ObjectChunk(ArrayTypeUtils.EMPTY_OBJECT_ARRAY, 0, 0);
    private static final ObjectChunk[] EMPTY_OBJECT_CHUNK_ARRAY = new ObjectChunk[0];
    T[] data;

    public static <T, ATTR extends Any> ObjectChunk<T, ATTR> getEmptyChunk() {
        return EMPTY;
    }

    static <T, ATTR extends Any> ObjectChunk<T, ATTR>[] getEmptyChunkArray() {
        return EMPTY_OBJECT_CHUNK_ARRAY;
    }

    public static <T> T[] makeArray(int capacity) {
        if (capacity == 0) {
            return ArrayTypeUtils.EMPTY_OBJECT_ARRAY;
        }
        return new Object[capacity];
    }

    public static <T, ATTR extends Any> ObjectChunk<T, ATTR> chunkWrap(T[] data) {
        return ObjectChunk.chunkWrap(data, 0, data.length);
    }

    public static <T, ATTR extends Any> ObjectChunk<T, ATTR> chunkWrap(T[] data, int offset, int capacity) {
        return new ObjectChunk<T, ATTR>(data, offset, capacity);
    }

    protected ObjectChunk(T[] data, int offset, int capacity) {
        super(data.length, offset, capacity);
        this.data = data;
    }

    @Override
    public final ChunkType getChunkType() {
        return ChunkType.Object;
    }

    public final T get(int index) {
        return this.data[this.offset + index];
    }

    public ObjectChunk<T, ATTR> slice(int offset, int capacity) {
        ChunkHelpers.checkSliceArgs(this.size, offset, capacity);
        return new ObjectChunk<T, ATTR>(this.data, this.offset + offset, capacity);
    }

    @Override
    public final void copyToChunk(int srcOffset, WritableChunk<? super ATTR> dest, int destOffset, int length) {
        WritableObjectChunk wDest = dest.asWritableObjectChunk();
        this.copyToTypedArray(srcOffset, wDest.data, wDest.offset + destOffset, length);
    }

    @Override
    public final void copyToArray(int srcOffset, Object dest, int destOffset, int length) {
        Object[] realType = (Object[])dest;
        this.copyToTypedArray(srcOffset, realType, destOffset, length);
    }

    public final void copyToTypedArray(int srcOffset, T[] destData, int destOffset, int length) {
        int sStart = this.offset + srcOffset;
        if (length >= 16) {
            System.arraycopy(this.data, sStart, destData, destOffset, length);
            return;
        }
        if (ChunkHelpers.canCopyForward(this.data, sStart, destData, destOffset, length)) {
            for (int ii = 0; ii < length; ++ii) {
                destData[destOffset + ii] = this.data[sStart + ii];
            }
            return;
        }
        for (int ii = length - 1; ii >= 0; --ii) {
            destData[destOffset + ii] = this.data[sStart + ii];
        }
    }

    @Override
    public final boolean isAlias(Object array) {
        return this.data == array;
    }

    @Override
    public final boolean isAlias(Chunk<?> chunk) {
        return chunk.isAlias(this.data);
    }

    @Override
    public final <V extends Chunk.Visitor<ATTR>> V walk(V visitor) {
        visitor.visit(this);
        return visitor;
    }

    public <T_DERIV extends T> ObjectChunk<T_DERIV, ATTR> asTypedObjectChunk() {
        return this;
    }

    public static <T, ATTR extends Any, ATTR_DERIV extends ATTR> ObjectChunk<T, ATTR_DERIV> downcast(ObjectChunk<T, ATTR> self) {
        return self;
    }

    public final int binarySearch(Object key) {
        return Arrays.binarySearch(this.data, this.offset, this.offset + this.size, key);
    }

    public final int binarySearch(int fromIndexInclusive, int toIndexExclusive, Object key) {
        return Arrays.binarySearch(this.data, this.offset + fromIndexInclusive, this.offset + toIndexExclusive, key);
    }
}

